/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public class VolcanicRockBlock
extends Block {
    public VolcanicRockBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        int i;
        if (rand.nextInt(10) == 0) {
            level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.75, (double)pos.getZ() + 0.5, SoundEvents.LAVA_POP, SoundSource.BLOCKS, 0.5f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.6f, false);
        }
        if (rand.nextInt(5) == 0) {
            for (i = 0; i < rand.nextInt(1) + 1; ++i) {
                level.addParticle((ParticleOptions)ParticleTypes.LAVA, (double)pos.getX() + 0.5, (double)pos.getY() + 0.75, (double)pos.getZ() + 0.5, (double)(rand.nextFloat() / 2.0f), 5.0E-5, (double)(rand.nextFloat() / 2.0f));
            }
        }
        if (rand.nextInt(5) == 0) {
            for (i = 0; i < rand.nextInt(1) + 1; ++i) {
                level.addParticle((ParticleOptions)ParticleTypes.LAVA, (double)pos.getX() + 0.5, (double)pos.getY() + 0.75, (double)pos.getZ() + 0.5, (double)(rand.nextFloat() / 2.0f), 5.0E-5, (double)(rand.nextFloat() / 2.0f));
            }
        }
        for (i = 0; i < rand.nextInt(2) + 2; ++i) {
            SimpleParticleType simpleparticletype = ParticleTypes.CAMPFIRE_COSY_SMOKE;
            level.addAlwaysVisibleParticle((ParticleOptions)simpleparticletype, true, (double)pos.getX() + 0.5 + rand.nextDouble() / 3.0 * (double)(rand.nextBoolean() ? 1 : -1), (double)pos.getY() + rand.nextDouble() + rand.nextDouble(), (double)pos.getZ() + 0.5 + rand.nextDouble() / 3.0 * (double)(rand.nextBoolean() ? 1 : -1), 0.0, 0.07, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5 + rand.nextDouble() / 4.0 * (double)(rand.nextBoolean() ? 1 : -1), (double)pos.getY() + 0.65, (double)pos.getZ() + 0.5 + rand.nextDouble() / 4.0 * (double)(rand.nextBoolean() ? 1 : -1), 0.0, 0.005, 0.0);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.below();
        return level.getBlockState(blockpos).isFaceSturdy((BlockGetter)level, blockpos, Direction.UP);
    }

    public boolean canBeReplaced(BlockState state_, Fluid fluid_) {
        return false;
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean useShapeForLightOcclusion(BlockState state_) {
        return true;
    }
}

