/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block.base;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.jitl.common.block.base.JBasePressurePlateBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class JPressurePlateBlock
extends JBasePressurePlateBlock {
    public static final MapCodec<JPressurePlateBlock> CODEC = RecordCodecBuilder.mapCodec(p_432675_ -> p_432675_.group((App)BlockSetType.CODEC.fieldOf("block_set_type").forGetter(p_304917_ -> p_304917_.type), (App)JPressurePlateBlock.propertiesCodec()).apply((Applicative)p_432675_, JPressurePlateBlock::new));
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public MapCodec<JPressurePlateBlock> codec() {
        return CODEC;
    }

    public JPressurePlateBlock(BlockSetType type, BlockBehaviour.Properties properties) {
        super(properties, type);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected int getSignalForState(BlockState state) {
        return (Boolean)state.getValue((Property)POWERED) != false ? 15 : 0;
    }

    @Override
    protected BlockState setSignalForState(BlockState state, int strength) {
        return (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(strength > 0));
    }

    @Override
    protected int getSignalStrength(Level level, BlockPos pos) {
        Class<Entity> oclass = switch (this.type.pressurePlateSensitivity()) {
            case BlockSetType.PressurePlateSensitivity.EVERYTHING -> Entity.class;
            case BlockSetType.PressurePlateSensitivity.MOBS -> LivingEntity.class;
            default -> throw new MatchException(null, null);
        };
        return JPressurePlateBlock.getEntityCount(level, TOUCH_AABB.move(pos), oclass) > 0 ? 15 : 0;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED});
    }
}

