/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.capability.stats;

import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.client.stats.PacketPlayerStats;
import net.jitl.core.data.JNetworkRegistry;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.util.ValueIOSerializable;

public class PlayerStats
implements ValueIOSerializable {
    private boolean hasBlizzard;
    private int sentacoins;
    private int overworldLevel;
    private int netherLevel;
    private int endLevel;
    private int eucaLevel;
    private int boilLevel;
    private int frozenLevel;
    private int depthsLevel;
    private int corbaLevel;
    private int cloudiaLevel;
    private int terraniaLevel;
    private int senterianLevel;
    private float overworldXP;
    private float netherXP;
    private float endXP;
    private float eucaXP;
    private float boilXP;
    private float frozenXP;
    private float depthsXP;
    private float corbaXP;
    private float cloudiaXP;
    private float terraniaXP;
    private float senterianXP;

    public void copyFrom(PlayerStats stats) {
        this.hasBlizzard = stats.hasBlizzard;
        for (EnumKnowledge k : EnumKnowledge.values()) {
            this.setLevel(k, stats.getLevel(k));
            this.setXP(k, stats.getXP(k));
        }
    }

    public boolean hasBlizzard() {
        return this.hasBlizzard;
    }

    public void setBlizzard(boolean blizzard) {
        this.hasBlizzard = blizzard;
    }

    public int getSentacoins() {
        return this.sentacoins;
    }

    public void setSentacoins(int value) {
        this.sentacoins = value;
    }

    public boolean useSentacoins(int amount) {
        if (this.sentacoins >= amount) {
            this.sentacoins -= amount;
            return true;
        }
        return false;
    }

    public void addSentacoins(int amount) {
        this.sentacoins += amount;
    }

    public int getLevel(EnumKnowledge knowledge) {
        int level = 0;
        switch (knowledge) {
            case OVERWORLD: {
                level = this.overworldLevel;
                break;
            }
            case NETHER: {
                level = this.netherLevel;
                break;
            }
            case END: {
                level = this.endLevel;
                break;
            }
            case EUCA: {
                level = this.eucaLevel;
                break;
            }
            case BOIL: {
                level = this.boilLevel;
                break;
            }
            case FROZEN: {
                level = this.frozenLevel;
                break;
            }
            case DEPTHS: {
                level = this.depthsLevel;
                break;
            }
            case CORBA: {
                level = this.corbaLevel;
                break;
            }
            case CLOUDIA: {
                level = this.cloudiaLevel;
                break;
            }
            case TERRANIA: {
                level = this.terraniaLevel;
                break;
            }
            case SENTERIAN: {
                level = this.senterianLevel;
            }
        }
        return level;
    }

    public void addLevel(EnumKnowledge knowledge, int level) {
        switch (knowledge) {
            case OVERWORLD: {
                this.overworldLevel += level;
                break;
            }
            case NETHER: {
                this.netherLevel += level;
                break;
            }
            case END: {
                this.endLevel += level;
                break;
            }
            case EUCA: {
                this.eucaLevel += level;
                break;
            }
            case BOIL: {
                this.boilLevel += level;
                break;
            }
            case FROZEN: {
                this.frozenLevel += level;
                break;
            }
            case DEPTHS: {
                this.depthsLevel += level;
                break;
            }
            case CORBA: {
                this.corbaLevel += level;
                break;
            }
            case CLOUDIA: {
                this.cloudiaLevel += level;
                break;
            }
            case TERRANIA: {
                this.terraniaLevel += level;
                break;
            }
            case SENTERIAN: {
                this.senterianLevel += level;
            }
        }
    }

    public void setLevel(EnumKnowledge knowledge, int level) {
        switch (knowledge) {
            case OVERWORLD: {
                this.overworldLevel = level;
                break;
            }
            case NETHER: {
                this.netherLevel = level;
                break;
            }
            case END: {
                this.endLevel = level;
                break;
            }
            case EUCA: {
                this.eucaLevel = level;
                break;
            }
            case BOIL: {
                this.boilLevel = level;
                break;
            }
            case FROZEN: {
                this.frozenLevel = level;
                break;
            }
            case DEPTHS: {
                this.depthsLevel = level;
                break;
            }
            case CORBA: {
                this.corbaLevel = level;
                break;
            }
            case CLOUDIA: {
                this.cloudiaLevel = level;
                break;
            }
            case TERRANIA: {
                this.terraniaLevel = level;
                break;
            }
            case SENTERIAN: {
                this.senterianLevel = level;
            }
        }
    }

    public void setXP(EnumKnowledge knowledge, float amount) {
        switch (knowledge) {
            case OVERWORLD: {
                this.overworldXP = amount;
                break;
            }
            case NETHER: {
                this.netherXP = amount;
                break;
            }
            case END: {
                this.endXP = amount;
                break;
            }
            case EUCA: {
                this.eucaXP = amount;
                break;
            }
            case BOIL: {
                this.boilXP = amount;
                break;
            }
            case FROZEN: {
                this.frozenXP = amount;
                break;
            }
            case DEPTHS: {
                this.depthsXP = amount;
                break;
            }
            case CORBA: {
                this.corbaXP = amount;
                break;
            }
            case CLOUDIA: {
                this.cloudiaXP = amount;
                break;
            }
            case TERRANIA: {
                this.terraniaXP = amount;
                break;
            }
            case SENTERIAN: {
                this.senterianXP = amount;
            }
        }
    }

    public float getXP(EnumKnowledge knowledge) {
        float XP = 0.0f;
        switch (knowledge) {
            case OVERWORLD: {
                XP = this.overworldXP;
                break;
            }
            case NETHER: {
                XP = this.netherXP;
                break;
            }
            case END: {
                XP = this.endXP;
                break;
            }
            case EUCA: {
                XP = this.eucaXP;
                break;
            }
            case BOIL: {
                XP = this.boilXP;
                break;
            }
            case FROZEN: {
                XP = this.frozenXP;
                break;
            }
            case DEPTHS: {
                XP = this.depthsXP;
                break;
            }
            case CORBA: {
                XP = this.corbaXP;
                break;
            }
            case CLOUDIA: {
                XP = this.cloudiaXP;
                break;
            }
            case TERRANIA: {
                XP = this.terraniaXP;
                break;
            }
            case SENTERIAN: {
                XP = this.senterianXP;
            }
        }
        return XP;
    }

    public void addXP(EnumKnowledge knowledge, float amount, Player player) {
        if (this.getXP(knowledge) + amount >= this.getLevelCapacity(this.getLevel(knowledge))) {
            this.setXP(knowledge, this.getXP(knowledge) + amount - this.getLevelCapacity(this.getLevel(knowledge)));
            this.addLevel(knowledge, 1);
        } else {
            this.setXP(knowledge, this.getXP(knowledge) + amount);
        }
        this.sendPacket(knowledge, player);
    }

    public float getTotal(EnumKnowledge knowledge) {
        float amount = 0.0f;
        for (int i = 0; i < this.getLevel(knowledge); ++i) {
            amount += this.getLevelCapacity(this.getLevel(knowledge));
        }
        return amount + this.getXP(knowledge);
    }

    public float remove(EnumKnowledge knowledge, float amount) {
        float total = this.getTotal(knowledge);
        if (amount > total) {
            float left = amount - total;
            this.setLevel(knowledge, 0);
            this.setXP(knowledge, 0.0f);
            return left;
        }
        if (this.getXP(knowledge) - amount < 0.0f) {
            amount -= this.getXP(knowledge);
            while (amount > 0.0f) {
                float levelCapacity = this.getLevelCapacity(this.getLevel(knowledge));
                if (levelCapacity > amount) {
                    this.setLevel(knowledge, this.getLevel(knowledge) - 1);
                    this.setXP(knowledge, levelCapacity - amount);
                    return 0.0f;
                }
                amount -= levelCapacity;
                this.setLevel(knowledge, this.getLevel(knowledge) - 1);
            }
            throw new IllegalStateException("This shouldn't be achieved, because if all levels' at capacity is smaller than removed amount, it should be cut in the start of the method");
        }
        this.setXP(knowledge, this.getXP(knowledge) - amount);
        return 0.0f;
    }

    public void sendPacket(EnumKnowledge k, Player player) {
        if (player instanceof ServerPlayer) {
            JNetworkRegistry.sendToPlayer((ServerPlayer)player, new PacketPlayerStats(this.hasBlizzard(), this.getSentacoins(), this.getXP(k), this.getLevel(k), k));
        }
    }

    public void update(Player player) {
        for (EnumKnowledge k : EnumKnowledge.values()) {
            if (this.getLevel(k) >= 100) {
                this.setLevel(k, 100);
                this.setXP(k, 0.0f);
            }
            this.sendPacket(k, player);
        }
    }

    public boolean isCompleted(EnumKnowledge k) {
        return this.getLevel(k) >= 100;
    }

    public float getLevelCapacity(int level) {
        return level >= 5 ? 50.0f : (level >= 10 ? 60.0f : (level >= 15 ? 70.0f : (level >= 20 ? 80.0f : (level >= 30 ? 90.0f : (level >= 40 ? 100.0f : 30.0f)))));
    }

    public void serialize(ValueOutput valueOutput) {
        valueOutput.putBoolean("hasBlizzard", this.hasBlizzard);
        valueOutput.putInt("sentacoins", this.sentacoins);
        valueOutput.putInt("overworld_level", this.overworldLevel);
        valueOutput.putInt("nether_level", this.netherLevel);
        valueOutput.putInt("end_level", this.endLevel);
        valueOutput.putInt("euca_level", this.eucaLevel);
        valueOutput.putInt("boil_level", this.boilLevel);
        valueOutput.putInt("frozen_level", this.frozenLevel);
        valueOutput.putInt("depths_level", this.depthsLevel);
        valueOutput.putInt("corba_level", this.corbaLevel);
        valueOutput.putInt("cloudia_level", this.cloudiaLevel);
        valueOutput.putInt("terrania_level", this.terraniaLevel);
        valueOutput.putInt("senterian_level", this.senterianLevel);
        valueOutput.putFloat("overworld_xp", this.overworldXP);
        valueOutput.putFloat("nether_xp", this.netherXP);
        valueOutput.putFloat("end_xp", this.endXP);
        valueOutput.putFloat("euca_xp", this.eucaXP);
        valueOutput.putFloat("boil_xp", this.boilXP);
        valueOutput.putFloat("frozen_xp", this.frozenXP);
        valueOutput.putFloat("depths_xp", this.depthsXP);
        valueOutput.putFloat("corba_xp", this.corbaXP);
        valueOutput.putFloat("cloudia_xp", this.cloudiaXP);
        valueOutput.putFloat("terrania_xp", this.terraniaXP);
        valueOutput.putFloat("senterian_xp", this.senterianXP);
    }

    public void deserialize(ValueInput valueInput) {
        this.hasBlizzard = valueInput.getBooleanOr("hasBlizzard", false);
        this.sentacoins = valueInput.getIntOr("sentacoins", 0);
        this.overworldLevel = valueInput.getIntOr("overworld_level", 0);
        this.netherLevel = valueInput.getIntOr("nether_level", 0);
        this.endLevel = valueInput.getIntOr("end_level", 0);
        this.eucaLevel = valueInput.getIntOr("euca_level", 0);
        this.boilLevel = valueInput.getIntOr("boil_level", 0);
        this.frozenLevel = valueInput.getIntOr("frozen_level", 0);
        this.depthsLevel = valueInput.getIntOr("depths_level", 0);
        this.corbaLevel = valueInput.getIntOr("corba_level", 0);
        this.cloudiaLevel = valueInput.getIntOr("cloudia_level", 0);
        this.terraniaLevel = valueInput.getIntOr("terrania_level", 0);
        this.senterianLevel = valueInput.getIntOr("senterian_level", 0);
        this.overworldXP = valueInput.getFloatOr("overworld_xp", 0.0f);
        this.netherXP = valueInput.getFloatOr("nether_xp", 0.0f);
        this.endXP = valueInput.getFloatOr("end_xp", 0.0f);
        this.eucaXP = valueInput.getFloatOr("euca_xp", 0.0f);
        this.boilXP = valueInput.getFloatOr("boil_xp", 0.0f);
        this.frozenXP = valueInput.getFloatOr("frozen_xp", 0.0f);
        this.depthsXP = valueInput.getFloatOr("depths_xp", 0.0f);
        this.corbaXP = valueInput.getFloatOr("corba_xp", 0.0f);
        this.cloudiaXP = valueInput.getFloatOr("cloudia_xp", 0.0f);
        this.terraniaXP = valueInput.getFloatOr("terrania_xp", 0.0f);
        this.senterianXP = valueInput.getFloatOr("senterian_xp", 0.0f);
    }
}

