/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.boss;

import java.util.EnumSet;
import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.entity.base.JBossEntity;
import net.jitl.common.entity.boss.BossCrystal;
import net.jitl.common.entity.goal.AttackWhenDifficultGoal;
import net.jitl.common.entity.goal.IdleHealGoal;
import net.jitl.common.entity.nether.InfernoBlaze;
import net.jitl.core.init.internal.JEntities;
import net.jitl.core.init.internal.JLootTables;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;

public class Blazier
extends JBossEntity {
    private int spawnTimer;
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.blazier.idle");

    public Blazier(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.LAVA, 8.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
        this.spawnTimer = 0;
        this.setKnowledge(EnumKnowledge.NETHER, 10);
    }

    @Override
    public boolean showName() {
        return false;
    }

    public boolean fireImmune() {
        return true;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(4, (Goal)new BlazierAttackGoal(this));
        this.goalSelector.addGoal(1, (Goal)new IdleHealGoal((Mob)this, 4800));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new AttackWhenDifficultGoal((Mob)this, this));
        this.goalSelector.addGoal(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, null));
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)JSounds.BLAZIER_IDLE.get();
    }

    @Override
    protected SoundEvent getDeathSound() {
        return (SoundEvent)JSounds.BLAZIER_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return (SoundEvent)JSounds.BLAZIER_HURT.get();
    }

    public void tick() {
        super.tick();
        if (this.getHealth() <= 250.0f) {
            if (this.spawnTimer == 0 && !this.level().isClientSide()) {
                InfernoBlaze z = new InfernoBlaze((EntityType<? extends Monster>)((EntityType)JEntities.INFERNO_BLAZE_TYPE.get()), this.level());
                double posX = this.position().x;
                double posY = this.position().y;
                double posZ = this.position().z;
                z.setPos(posX + 3.0, posY, posZ);
                InfernoBlaze z1 = new InfernoBlaze((EntityType<? extends Monster>)((EntityType)JEntities.INFERNO_BLAZE_TYPE.get()), this.level());
                z1.setPos(posX - 3.0, posY, posZ);
                InfernoBlaze z2 = new InfernoBlaze((EntityType<? extends Monster>)((EntityType)JEntities.INFERNO_BLAZE_TYPE.get()), this.level());
                z2.setPos(posX, posY, posZ + 3.0);
                InfernoBlaze z3 = new InfernoBlaze((EntityType<? extends Monster>)((EntityType)JEntities.INFERNO_BLAZE_TYPE.get()), this.level());
                z3.setPos(posX, posY, posZ - 3.0);
                this.level().addFreshEntity((Entity)z);
                this.level().addFreshEntity((Entity)z1);
                this.level().addFreshEntity((Entity)z2);
                this.level().addFreshEntity((Entity)z3);
                this.spawnTimer = 500;
            }
            --this.spawnTimer;
        }
    }

    public static AttributeSupplier createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 850.0).add(Attributes.ATTACK_DAMAGE, 20.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.FOLLOW_RANGE, 80.0).add(Attributes.MOVEMENT_SPEED, 0.26).build();
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController("controller", 5, state -> state.setAndContinue(this.IDLE)));
    }

    @Override
    public boolean wantsToAttack(LivingEntity target, LivingEntity living) {
        return this.level().getDifficulty() != Difficulty.PEACEFUL;
    }

    @Override
    @Nullable
    protected BossCrystal.Type getDeathCrystalType() {
        return BossCrystal.Type.NETHER;
    }

    @Override
    public ResourceKey<LootTable> lootTable() {
        return JLootTables.BLAZIER_CRYSTAL;
    }

    @Override
    public boolean showBarWhenSpawned() {
        return true;
    }

    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    static class BlazierAttackGoal
    extends Goal {
        private final Blazier blazier;
        private int attackStep;
        private int attackTime;
        private int lastSeen;

        public BlazierAttackGoal(Blazier blazier) {
            this.blazier = blazier;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            LivingEntity livingentity = this.blazier.getTarget();
            return livingentity != null && livingentity.isAlive() && this.blazier.canAttack(livingentity);
        }

        public void start() {
            this.attackStep = 0;
        }

        public void stop() {
            this.lastSeen = 0;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            --this.attackTime;
            LivingEntity livingentity = this.blazier.getTarget();
            if (livingentity != null) {
                boolean flag = this.blazier.getSensing().hasLineOfSight((Entity)livingentity);
                this.lastSeen = flag ? 0 : ++this.lastSeen;
                double d0 = this.blazier.distanceToSqr((Entity)livingentity);
                if (d0 < 4.0) {
                    if (!flag) {
                        return;
                    }
                    if (this.attackTime <= 0) {
                        this.attackTime = 20;
                        this.blazier.doHurtTarget(BlazierAttackGoal.getServerLevel((Entity)this.blazier), (Entity)livingentity);
                    }
                    this.blazier.getMoveControl().setWantedPosition(livingentity.getX(), livingentity.getY(), livingentity.getZ(), 1.0);
                } else if (d0 < this.getFollowDistance() * this.getFollowDistance() && flag) {
                    double d1 = livingentity.getX() - this.blazier.getX();
                    double d2 = livingentity.getY(0.5) - this.blazier.getY(0.5);
                    double d3 = livingentity.getZ() - this.blazier.getZ();
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 60;
                        } else if (this.attackStep <= 4) {
                            this.attackTime = 6;
                        } else {
                            this.attackTime = 100;
                            this.attackStep = 0;
                        }
                        if (this.attackStep > 1) {
                            double d4 = Math.sqrt(Math.sqrt(d0)) * 0.5;
                            if (!this.blazier.isSilent()) {
                                this.blazier.level().levelEvent(null, 1018, this.blazier.blockPosition(), 0);
                            }
                            for (int i = 0; i < 1; ++i) {
                                Vec3 vec3 = new Vec3(this.blazier.getRandom().triangle(d1, 2.297 * d4), d2, this.blazier.getRandom().triangle(d3, 2.297 * d4));
                                LargeFireball fireball = new LargeFireball(this.blazier.level(), (LivingEntity)this.blazier, vec3.normalize(), 1);
                                fireball.setPos(fireball.getX(), this.blazier.getY(0.5) + 0.5, fireball.getZ());
                                this.blazier.level().addFreshEntity((Entity)fireball);
                            }
                        }
                    }
                    this.blazier.getLookControl().setLookAt((Entity)livingentity, 10.0f, 10.0f);
                } else if (this.lastSeen < 5) {
                    this.blazier.getMoveControl().setWantedPosition(livingentity.getX(), livingentity.getY(), livingentity.getZ(), 1.0);
                }
                super.tick();
            }
        }

        private double getFollowDistance() {
            return this.blazier.getAttributeValue(Attributes.FOLLOW_RANGE);
        }
    }
}

