/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.boss;

import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.entity.base.JFlyingBossEntity;
import net.jitl.common.entity.base.JFlyingEntity;
import net.jitl.common.entity.boss.BossCrystal;
import net.jitl.common.entity.goal.AttackWhenDifficultGoal;
import net.jitl.core.init.internal.JLootTables;
import net.jitl.core.init.internal.JParticleManager;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;

public class Scale
extends JFlyingBossEntity {
    private static final EntityDataAccessor<Boolean> DATA_IS_CHARGING = SynchedEntityData.defineId(Scale.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.scale.idle");

    public Scale(EntityType<? extends Scale> pEntityType, Level pLevel) {
        super((EntityType<? extends JFlyingEntity>)pEntityType, pLevel);
        this.setFlyingSpeed(0.2);
        this.setKnowledge(EnumKnowledge.DEPTHS, 10);
    }

    @Override
    public boolean showName() {
        return true;
    }

    @Override
    public void addGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new ShootFireballGoal(this));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new AttackWhenDifficultGoal(this, this));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, null));
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return SoundEvents.WITHER_AMBIENT;
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return SoundEvents.WITHER_HURT;
    }

    @Override
    public boolean despawnInPeaceful() {
        return false;
    }

    public static AttributeSupplier createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 1550.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.FOLLOW_RANGE, 80.0).add(Attributes.MOVEMENT_SPEED, 0.26).build();
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            for (int i = 0; i < 6; ++i) {
                this.level().addParticle((ParticleOptions)JParticleManager.CRYSTAL_FRUIT.get(), this.position().x + (this.random.nextDouble() - 0.5), this.position().y + this.random.nextDouble(), this.position().z + (this.random.nextDouble() - 0.5), (this.random.nextDouble() - 0.5) * 2.0, -this.random.nextDouble(), (this.random.nextDouble() - 0.5) * 2.0);
            }
        }
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController("controller", 5, state -> state.setAndContinue(this.IDLE)));
    }

    @Override
    public boolean wantsToAttack(LivingEntity target, LivingEntity living) {
        return this.level().getDifficulty() != Difficulty.PEACEFUL;
    }

    @Override
    @Nullable
    protected BossCrystal.Type getDeathCrystalType() {
        return BossCrystal.Type.DEPTHS;
    }

    @Override
    public ResourceKey<LootTable> lootTable() {
        return JLootTables.SCALE_CRYSTAL;
    }

    @Override
    public boolean showBarWhenSpawned() {
        return true;
    }

    public void setCharging(boolean pCharging) {
        this.entityData.set(DATA_IS_CHARGING, (Object)pCharging);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_IS_CHARGING, (Object)false);
    }

    public static class ShootFireballGoal
    extends Goal {
        private final Scale scale;
        public int chargeTime;

        public ShootFireballGoal(Scale pscale) {
            this.scale = pscale;
        }

        public boolean canUse() {
            return this.scale.getTarget() != null;
        }

        public void start() {
            this.chargeTime = 0;
        }

        public void stop() {
            this.scale.setCharging(false);
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            LivingEntity livingentity = this.scale.getTarget();
            if (livingentity != null) {
                if (livingentity.distanceToSqr((Entity)this.scale) < 4096.0 && this.scale.hasLineOfSight((Entity)livingentity)) {
                    Level level = this.scale.level();
                    ++this.chargeTime;
                    if (this.chargeTime == 10 && !this.scale.isSilent()) {
                        level.levelEvent((Entity)((Player)null), 1015, this.scale.blockPosition(), 0);
                    }
                    if (this.chargeTime == 20) {
                        Vec3 vec3 = this.scale.getViewVector(1.0f);
                        double d2 = livingentity.getX() - (this.scale.getX() + vec3.x * 4.0);
                        double d3 = livingentity.getY(0.5) - (0.5 + this.scale.getY(0.5));
                        double d4 = livingentity.getZ() - (this.scale.getZ() + vec3.z * 4.0);
                        Vec3 vec31 = new Vec3(d2, d3, d4);
                        if (!this.scale.isSilent()) {
                            level.levelEvent(null, 1016, this.scale.blockPosition(), 0);
                        }
                        LargeFireball fireball = new LargeFireball(level, (LivingEntity)this.scale, vec31.normalize(), 1);
                        fireball.setPos(this.scale.getX() + vec3.x * 4.0, this.scale.getY(0.5) + 0.5, fireball.getZ() + vec3.z * 4.0);
                        level.addFreshEntity((Entity)fireball);
                        this.chargeTime = -40;
                    }
                } else if (this.chargeTime > 0) {
                    --this.chargeTime;
                }
                this.scale.setCharging(this.chargeTime > 10);
            }
        }
    }
}

