/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.corba;

import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.entity.base.JMonsterEntity;
import net.jitl.core.init.internal.JBlocks;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;

public class CorbanianMollusk
extends JMonsterEntity {
    private final RawAnimation MOVING = RawAnimation.begin().thenLoop("animation.corbanian_mollusk.walking");
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.corbanian_mollusk.idle");

    public CorbanianMollusk(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setKnowledge(EnumKnowledge.CORBA, 5.0f);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(1, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.goalSelector.addGoal(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public static AttributeSupplier createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 52.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.FOLLOW_RANGE, 25.0).add(Attributes.MOVEMENT_SPEED, 0.1).build();
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)JSounds.TERRA_SLUG.get();
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)JSounds.TERRA_SLUG_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)JSounds.TERRA_SLUG_DEATH.get();
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController("controller", 5, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(this.MOVING);
            }
            return state.setAndContinue(this.IDLE);
        }));
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide()) {
            if (!EventHooks.canEntityGrief((ServerLevel)((ServerLevel)this.level()), (Entity)this)) {
                return;
            }
            BlockState slime = ((Block)JBlocks.SLIME.get()).defaultBlockState();
            for (int i = 0; i < 4; ++i) {
                int j = Mth.floor((double)(this.getX() + (double)((float)(i % 2 * 2 - 1) * 0.25f)));
                int k = Mth.floor((double)this.getY());
                int l = Mth.floor((double)(this.getZ() + (double)((float)(i / 2 % 2 * 2 - 1) * 0.25f)));
                BlockPos blockpos = new BlockPos(j, k, l);
                if (!this.level().isEmptyBlock(blockpos) || !slime.canSurvive((LevelReader)this.level(), blockpos)) continue;
                this.level().setBlockAndUpdate(blockpos, slime);
                this.level().gameEvent((Holder)GameEvent.BLOCK_PLACE, blockpos, GameEvent.Context.of((Entity)this, (BlockState)slime));
            }
        }
    }
}

