/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.corba;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Objects;
import net.jitl.common.block.TotemBlock;
import net.jitl.core.init.internal.JBlocks;
import net.jitl.core.init.internal.JLootTables;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SpiritCrystal
extends PathfinderMob
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final NonNullList<ItemStack> storedItems = NonNullList.create();
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.spirit_crystal.idle");

    public SpiritCrystal(EntityType<? extends SpiritCrystal> entityType, Level world) {
        super(entityType, world);
        this.setDeltaMovement(0.0, 0.0, 0.0);
    }

    protected void registerGoals() {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController("controller", 5, state -> state.setAndContinue(this.IDLE)));
    }

    public static AttributeSupplier createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 100.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.FOLLOW_RANGE, 25.0).add(Attributes.MOVEMENT_SPEED, 0.26).build();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    protected InteractionResult mobInteract(Player playerEntity, InteractionHand hand) {
        int check_radius = 10;
        int totalAwakeTotems = 0;
        Level world = this.level();
        BlockPos entityPos = BlockPos.containing((Position)this.position());
        for (int x = -check_radius; x <= check_radius; ++x) {
            for (int z = -check_radius; z <= check_radius; ++z) {
                for (int y = -check_radius; y <= check_radius; ++y) {
                    BlockPos pos = entityPos.offset(x, y, z);
                    Block block = world.getBlockState(pos).getBlock();
                    if (block == JBlocks.TOTEM_BASE.get() || !(block instanceof TotemBlock) || !((Boolean)world.getBlockState(pos).getValue((Property)TotemBlock.AWAKE)).booleanValue()) continue;
                    ++totalAwakeTotems;
                }
            }
        }
        if (totalAwakeTotems >= 4 && !this.level().isClientSide()) {
            LootTable table = Objects.requireNonNull(this.level().getServer()).reloadableRegistries().getLootTable(JLootTables.SPIRIT_CRYSTAL);
            ObjectArrayList itemList = table.getRandomItems(new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)playerEntity).withParameter(LootContextParams.ORIGIN, (Object)playerEntity.position()).create(LootContextParamSets.GIFT));
            this.storedItems.addAll((Collection)itemList);
            for (ItemStack storedItem : this.storedItems) {
                ItemStack item = new ItemStack((ItemLike)storedItem.getItem());
                item.setCount(storedItem.getCount());
                ItemEntity entity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), item);
                this.level().addFreshEntity((Entity)entity);
            }
            this.playSound((SoundEvent)JSounds.CRYSTAL_PICKUP.get(), 1.0f, 1.0f);
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        return super.mobInteract(playerEntity, hand);
    }

    public boolean isNoGravity() {
        return true;
    }

    public boolean canCollideWith(Entity e) {
        return false;
    }

    public boolean canBeLeashed() {
        return false;
    }

    public boolean isAttackable() {
        return true;
    }

    public void push(Entity entity) {
    }

    protected void doPush(Entity entityIn) {
    }

    public boolean isPushable() {
        return false;
    }

    public boolean hurtServer(ServerLevel s, DamageSource source, float f) {
        return source.isCreativePlayer();
    }

    public boolean fireImmune() {
        return true;
    }
}

