/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.corba;

import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.entity.base.JNeutralMonster;
import net.jitl.core.helper.MathHelper;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;

public class TreeGolem
extends JNeutralMonster {
    private final RawAnimation MOVING = RawAnimation.begin().thenLoop("animation.tree_golem.walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.tree_golem.idle");

    public TreeGolem(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setKnowledge(EnumKnowledge.CORBA, 5.0f);
    }

    public static AttributeSupplier createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 62.0).add(Attributes.ATTACK_DAMAGE, 14.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.FOLLOW_RANGE, 25.0).add(Attributes.MOVEMENT_SPEED, 0.2).build();
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)JSounds.BUSH.get();
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)JSounds.BUSH_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)JSounds.BUSH_DEATH.get();
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController("controller", 5, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(this.MOVING);
            }
            return state.setAndContinue(this.IDLE);
        }));
    }

    public boolean doHurtTarget(ServerLevel level, Entity entity) {
        this.level().broadcastEntityEvent((Entity)this, (byte)1);
        float damage = (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
        float f1 = (int)damage > 0 ? damage / 2.0f + (float)this.random.nextInt((int)damage) : damage;
        boolean hurt = entity.hurtServer(level, this.damageSources().mobAttack((LivingEntity)this), f1);
        if (hurt) {
            entity.setDeltaMovement(entity.getDeltaMovement().add((double)(-MathHelper.sin(this.yRotO * (float)Math.PI / 180.0f)) * 4.0, 0.1, (double)MathHelper.cos(this.yRotO * (float)Math.PI / 180.0f) * 4.0));
        }
        return hurt;
    }
}

