/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.euca.npc;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import net.jitl.client.util.ChatUtils;
import net.jitl.common.entity.base.CurrencyForItemsTrade;
import net.jitl.common.entity.base.JVillagerEntity;
import net.jitl.common.entity.base.JVillagerMob;
import net.jitl.core.init.internal.JItems;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;

public class Crypian
extends JVillagerEntity {
    private static final EntityDataAccessor<Boolean> DATA_CAN_TRADE = SynchedEntityData.defineId(Crypian.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_ALLOY_HOUSE = SynchedEntityData.defineId(Crypian.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> TRADES = new Int2ObjectOpenHashMap((Map)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new CurrencyForItemsTrade((ItemLike)JItems.PERIDOT_GEMSTONE.get(), 1, (ItemLike)Items.COMPASS, 1, 12, 5)}));
    private final RawAnimation MOVING = RawAnimation.begin().thenLoop("animation.crypian.walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.crypian.idle");

    public Crypian(EntityType<? extends JVillagerEntity> type, Level worldIn) {
        super((EntityType<? extends JVillagerMob>)type, worldIn);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        int chance = this.random.nextInt(2);
        pBuilder.define(DATA_CAN_TRADE, (Object)(chance == 0 ? 1 : 0));
        pBuilder.define(DATA_ALLOY_HOUSE, (Object)false);
    }

    protected void rewardTradeXp(MerchantOffer merchantOffer) {
    }

    public void addAdditionalSaveData(ValueOutput compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("canTrade", ((Boolean)this.entityData.get(DATA_CAN_TRADE)).booleanValue());
        compound.putBoolean("alloyHouse", ((Boolean)this.entityData.get(DATA_ALLOY_HOUSE)).booleanValue());
    }

    public void readAdditionalSaveData(ValueInput compound) {
        super.readAdditionalSaveData(compound);
        this.setCanTrade(compound.getBooleanOr("canTrade", false));
        this.setAlloyHouse(compound.getBooleanOr("alloyHouse", true));
    }

    protected void updateTrades() {
    }

    public void setAlloyHouse(boolean canTrade) {
        this.entityData.set(DATA_ALLOY_HOUSE, (Object)canTrade);
    }

    public void setCanTrade(boolean canTrade) {
        this.entityData.set(DATA_CAN_TRADE, (Object)canTrade);
    }

    public boolean isAlloyHouse() {
        return (Boolean)this.entityData.get(DATA_ALLOY_HOUSE);
    }

    @Override
    public boolean canTrade() {
        return (Boolean)this.entityData.get(DATA_CAN_TRADE);
    }

    @Override
    protected Int2ObjectMap<VillagerTrades.ItemListing[]> getVillagerTrades() {
        return TRADES;
    }

    public static AttributeSupplier createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 100.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.FOLLOW_RANGE, 25.0).add(Attributes.MOVEMENT_SPEED, 0.26).build();
    }

    @Override
    @NotNull
    public InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand playerHand) {
        if (this.isAlive() && this.getTradingPlayer() == null && this.canTrade() && !this.isAlloyHouse()) {
            switch (this.random.nextInt(3)) {
                case 0: {
                    ChatUtils.addDialogStyleChat(player, "jitl.trader.crypian1");
                    break;
                }
                case 1: {
                    ChatUtils.addDialogStyleChat(player, "jitl.trader.crypian2");
                    break;
                }
                case 2: {
                    ChatUtils.addDialogStyleChat(player, "jitl.trader.crypian3");
                }
            }
            this.trade(player);
        } else if (this.isAlloyHouse()) {
            switch (this.random.nextInt(3)) {
                case 0: {
                    ChatUtils.addDialogStyleChat(player, "jitl.npc.crypian_alloy1");
                    break;
                }
                case 1: {
                    ChatUtils.addDialogStyleChat(player, "jitl.npc.crypian_alloy2");
                    break;
                }
                case 2: {
                    ChatUtils.addDialogStyleChat(player, "jitl.npc.crypian_alloy3");
                }
            }
        } else {
            switch (this.random.nextInt(2)) {
                case 0: {
                    ChatUtils.addDialogStyleChat(player, "jitl.npc.crypian1");
                    break;
                }
                case 1: {
                    ChatUtils.addDialogStyleChat(player, "jitl.npc.crypian2");
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController("controller", 5, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(this.MOVING);
            }
            return state.setAndContinue(this.IDLE);
        }));
    }
}

