/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.projectile;

import net.jitl.common.entity.projectile.JThrowableProjectile;
import net.jitl.core.init.internal.JParticleManager;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class BouncingProjectileEntity
extends JThrowableProjectile {
    private int bounces = 0;

    public BouncingProjectileEntity(EntityType<? extends BouncingProjectileEntity> type, Level world) {
        super(type, world);
    }

    public BouncingProjectileEntity(EntityType<? extends BouncingProjectileEntity> type, int dam, Level world, LivingEntity thrower) {
        super(type, dam, world, thrower);
        this.setBouncy();
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 3) {
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)JParticleManager.CLOUDIA_PORTAL.get(), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    public void onHitBlock(BlockHitResult result) {
        Vec3 vec = this.getDeltaMovement();
        double x = vec.x;
        double y = vec.y;
        double z = vec.z;
        if (result.getDirection() == Direction.DOWN || result.getDirection() == Direction.UP) {
            this.lerpMotion(new Vec3(x * 0.8, y * -0.8, z * 0.8));
        } else if (result.getDirection() == Direction.EAST || result.getDirection() == Direction.WEST) {
            this.lerpMotion(new Vec3(x * -0.8, y * 0.8, z * 0.8));
        } else if (result.getDirection() == Direction.NORTH || result.getDirection() == Direction.SOUTH) {
            this.lerpMotion(new Vec3(x * 0.8, y * 0.8, z * -0.8));
        }
        if (this.bounces > 6) {
            this.discard();
        }
        ++this.bounces;
    }
}

