/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.projectile;

import net.jitl.common.entity.projectile.DamagingProjectileEntity;
import net.jitl.core.init.internal.JEntities;
import net.jitl.core.init.internal.JItems;
import net.jitl.core.init.internal.JParticleManager;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class FloroMudEntity
extends DamagingProjectileEntity
implements ItemSupplier {
    public FloroMudEntity(EntityType<FloroMudEntity> type, Level world) {
        super(type, world);
    }

    public FloroMudEntity(EntityType<FloroMudEntity> type, Level world, LivingEntity thrower, float damage) {
        super(type, world, thrower, damage);
    }

    public FloroMudEntity(Level world, LivingEntity thrower, float damage) {
        super((EntityType<? extends DamagingProjectileEntity>)((EntityType)JEntities.FLORO_MUD_TYPE.get()), world, thrower, damage);
    }

    @Override
    public void onClientTick() {
        super.onClientTick();
        int count = 2;
        Vec3 vector3d = this.getDeltaMovement();
        double d0 = this.getX() + vector3d.x;
        double d1 = this.getY() + vector3d.y;
        double d2 = this.getZ() + vector3d.z;
        for (int i = 0; i < count; ++i) {
            this.level().addParticle((ParticleOptions)JParticleManager.MUD.get(), d0 - vector3d.x * 0.25 + this.random.nextDouble() * 0.6 - 0.3, d1 - vector3d.y + 0.25, d2 - vector3d.z * 0.25 + this.random.nextDouble() * 0.6 - 0.3, vector3d.x, vector3d.y, vector3d.z);
        }
    }

    @Override
    protected void onEntityImpact(HitResult result, Entity target) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (target instanceof LivingEntity && target.hurtServer(level2, this.damageSources().thrown((Entity)this, this.getOwner()), this.getDamage())) {
                MobEffectInstance effectInstance = new MobEffectInstance(MobEffects.SLOWNESS, 20);
                ((LivingEntity)target).addEffect(effectInstance);
            }
        }
    }

    @Override
    protected void onHit(@NotNull HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide()) {
            if (result.getType() != HitResult.Type.MISS) {
                this.level().playSound(null, BlockPos.containing((Position)result.getLocation()), (SoundEvent)JSounds.MUD_BLOCK_BREAK.get(), SoundSource.AMBIENT, 1.0f, 1.5f);
            }
        } else {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    protected double getDefaultGravity() {
        return 0.03f;
    }

    @NotNull
    public ItemStack getItem() {
        return new ItemStack((ItemLike)JItems.MUD_BALL.get());
    }
}

