/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.projectile;

import javax.annotation.Nullable;
import net.jitl.common.entity.projectile.AbstractKnifeEntity;
import net.jitl.core.init.internal.JEntities;
import net.jitl.core.init.internal.JItems;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class KnifeEntity
extends AbstractKnifeEntity
implements ItemSupplier {
    private static final EntityDataAccessor<ItemStack> STACK = SynchedEntityData.defineId(KnifeEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private int durability;

    public KnifeEntity(EntityType<KnifeEntity> type, Level world) {
        super(type, world);
    }

    public KnifeEntity(LivingEntity owner, Level worldIn, ItemStack stack, float damage, @Nullable ItemStack weapon) {
        super((EntityType<? extends AbstractArrow>)((EntityType)JEntities.KNIFE_TYPE.get()), worldIn, owner, weapon);
        this.setBaseDamage(damage);
        this.setStack(stack.copy());
    }

    @NotNull
    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return (SoundEvent)JSounds.KNIFE.get();
    }

    @Override
    public void onClientTick() {
        super.onClientTick();
        if (this.isFireKnife(this.getStack().getItem())) {
            double d0 = this.getX() + 0.0;
            double d1 = this.getY() + 0.0;
            double d2 = this.getZ() + 0.0;
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public boolean isFireKnife(Item item) {
        return item == JItems.MOLTEN_KNIFE.get() || item == JItems.CHARRED_KNIFE.get();
    }

    protected void onHitEntity(@NotNull EntityHitResult entityRayTraceResult_) {
        Entity entity = entityRayTraceResult_.getEntity();
        if (entity instanceof LivingEntity && entity != this.getOwner()) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                if (entity.hurtServer(level2, this.damageSources().thrown((Entity)this, this.getOwner()), (float)this.baseDamage) && this.isFireKnife(this.getStack().getItem())) {
                    entity.setRemainingFireTicks(200);
                }
                this.playSound((SoundEvent)JSounds.KNIFE.get(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
            }
        } else {
            super.onHitEntity(entityRayTraceResult_);
        }
    }

    @Override
    public void addAdditionalSaveData(ValueOutput nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt("dur", this.getStack().getDamageValue());
        nbt.store("stack", ItemStack.CODEC, (Object)this.getStack());
    }

    @Override
    public void readAdditionalSaveData(ValueInput nbt) {
        super.readAdditionalSaveData(nbt);
        this.durability = nbt.getIntOr("dur", 0);
        this.setStack(nbt.read("stack", ItemStack.CODEC).orElse(this.getDefaultPickupItem()));
        if (this.getStack().isEmpty()) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    protected ItemStack getDefaultPickupItem() {
        return this.getPickupItem();
    }

    private void setStack(ItemStack stack) {
        this.getEntityData().set(STACK, (Object)stack);
    }

    private ItemStack getStack() {
        return (ItemStack)this.getEntityData().get(STACK);
    }

    @Override
    @NotNull
    public Item pickupItem() {
        ItemStack item = this.getStack().copy();
        item.setDamageValue(this.durability);
        return item.getItem();
    }

    @NotNull
    public ItemStack getItem() {
        ItemStack stack = this.getStack();
        return stack.isEmpty() ? new ItemStack((ItemLike)JItems.IRON_THROWING_KNIFE.get()) : stack;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(STACK, (Object)ItemStack.EMPTY);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (key == STACK) {
            this.getStack().setEntityRepresentation((Entity)this);
        }
        super.onSyncedDataUpdated(key);
    }
}

