/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.projectile;

import javax.annotation.Nullable;
import net.jitl.core.init.internal.JEntities;
import net.jitl.core.init.internal.JItems;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class MagicBombEntity
extends AbstractArrow
implements ItemSupplier {
    private static final ItemStack DEFAULT_ARROW_STACK = new ItemStack((ItemLike)JItems.MAGIC_BOMB.get());

    public MagicBombEntity(EntityType<? extends AbstractArrow> type, Level world) {
        super(type, world);
    }

    public MagicBombEntity(Level worldIn, LivingEntity player, float damage, @Nullable ItemStack weapon) {
        super((EntityType)JEntities.MAGIC_BOMB_TYPE.get(), player, worldIn, DEFAULT_ARROW_STACK, weapon);
        this.setBaseDamage(damage);
    }

    @NotNull
    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return (SoundEvent)JSounds.KNIFE.get();
    }

    protected void onHitEntity(@NotNull EntityHitResult entityRayTraceResult_) {
        Entity entity = entityRayTraceResult_.getEntity();
        if (entity instanceof LivingEntity && entity != this.getOwner()) {
            ServerLevel level;
            Level level2;
            if (!this.level().isClientSide() && (level2 = this.level()) instanceof ServerLevel && entity.hurtServer(level = (ServerLevel)level2, this.damageSources().thrown((Entity)this, this.getOwner()), (float)this.baseDamage)) {
                this.level().explode((Entity)this, this.position().x, this.position().y, this.position().z, 2.0f, Level.ExplosionInteraction.BLOCK);
                this.remove(Entity.RemovalReason.DISCARDED);
            }
            this.playSound((SoundEvent)JSounds.BOTTLE_PLUG.get(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
        } else {
            super.onHitEntity(entityRayTraceResult_);
        }
    }

    public void tick() {
        super.tick();
        if (this.isInGround() && this.collidedWith() != null && this.collidedWith() != this.getOwner() && !this.level().isClientSide()) {
            this.level().explode((Entity)this, this.position().x, this.position().y, this.position().z, 2.0f, Level.ExplosionInteraction.BLOCK);
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public Entity collidedWith() {
        for (Entity entity : this.level().getEntities((Entity)this, this.getBoundingBox())) {
            if (!(entity instanceof LivingEntity)) continue;
            return entity;
        }
        return null;
    }

    protected boolean tryPickup(Player pPlayer) {
        return super.tryPickup(pPlayer);
    }

    @NotNull
    public ItemStack getPickupItem() {
        return new ItemStack((ItemLike)JItems.MAGIC_BOMB.get());
    }

    protected ItemStack getDefaultPickupItem() {
        return this.getPickupItem();
    }

    @NotNull
    public ItemStack getItem() {
        return new ItemStack((ItemLike)JItems.MAGIC_BOMB.get());
    }
}

