/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import net.jitl.common.capability.gear.PlayerArmor;
import net.jitl.common.items.base.JArmorItem;
import net.jitl.common.items.base.JSwordItem;
import net.jitl.common.items.gear.FullArmorAbility;
import net.jitl.common.items.gear.JGear;
import net.jitl.core.init.internal.JDataAttachments;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.ArmorMaterials;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="jitl")
public class GearAbilityHandler {
    @SubscribeEvent
    public static void handleTick(PlayerTickEvent.Post event) {
        FullArmorAbility fullSet;
        PlayerArmor armor;
        ArrayList<ItemStack> stacks;
        Player player = event.getEntity();
        ItemStack hand = player.getMainHandItem();
        Item item = hand.getItem();
        if (item instanceof JGear && !(item instanceof JArmorItem)) {
            ((JGear)hand.getItem()).getAbility().tick((LivingEntity)player, player.level(), hand);
        }
        if ((item = (hand = player.getOffhandItem()).getItem()) instanceof JGear && !(item instanceof JArmorItem)) {
            ((JGear)hand.getItem()).getAbility().tick((LivingEntity)player, player.level(), hand);
        }
        if ((stacks = (armor = (PlayerArmor)event.getEntity().getData(JDataAttachments.PLAYER_ARMOR)).getArmor()) != null) {
            for (ItemStack stack : stacks) {
                if (!(stack.getItem() instanceof JArmorItem)) continue;
                Objects.requireNonNull(((JArmorItem)stack.getItem()).getAbility()).tick((LivingEntity)player, player.level(), stack);
            }
        }
        if ((fullSet = armor.getFullArmor()) != null) {
            fullSet.tick(player);
        }
    }

    @SubscribeEvent
    public static void handleIncomingAttack(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getDirectEntity();
        if (entity != null) {
            Object object;
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                ItemStack stack = living.getMainHandItem();
                Item item = stack.getItem();
                if (item instanceof JGear) {
                    ((JGear)item).getAbility().attackTarget(living, stack, event);
                }
            } else if (entity.getType() == EntityType.ARROW && (object = ((Arrow)entity).getOwner()) instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)object;
                for (EquipmentSlot equipmentSlot : EquipmentSlotGroup.ARMOR) {
                    Item current = owner.getItemBySlot(equipmentSlot).getItem();
                    if (current instanceof JArmorItem && ((JArmorItem)current).getMaterial() == ArmorMaterials.LEATHER) continue;
                    return;
                }
                event.setNewDamage(event.getOriginalDamage() + 5.0f);
            }
        }
    }

    @SubscribeEvent
    public static void handleDamageDealt(LivingDamageEvent.Pre event) {
        PlayerArmor armor;
        LivingEntity entity = event.getEntity();
        ItemStack stack = entity.getMainHandItem();
        Item item = stack.getItem();
        if (item instanceof JGear) {
            ((JGear)item).getAbility().damageTarget(entity, stack, (LivingDamageEvent)event);
        }
        if ((armor = (PlayerArmor)event.getEntity().getData(JDataAttachments.PLAYER_ARMOR)).getFullArmor() != null) {
            armor.getFullArmor().hit(event);
        }
    }

    @SubscribeEvent
    public static void handleInteraction(PlayerInteractEvent.LeftClickBlock event) {
        Item item = event.getItemStack().getItem();
        if (item instanceof JGear) {
            JGear item2 = (JGear)item;
            item2.getAbility().playerInteract((PlayerInteractEvent)event);
        }
    }

    @SubscribeEvent
    public static void breakBlock(BlockEvent.BreakEvent event) {
        Item item = event.getPlayer().getMainHandItem().getItem();
        if (item instanceof JGear) {
            JGear item2 = (JGear)item;
            item2.getAbility().breakBlock(event.getPlayer().getMainHandItem(), event.getPlayer().level(), event.getState(), event.getPos(), event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void breakSpeed(PlayerEvent.BreakSpeed event) {
        Item item = event.getEntity().getMainHandItem().getItem();
        if (item instanceof JGear) {
            JGear item2 = (JGear)item;
            event.setNewSpeed(item2.getAbility().blockBreakSpeed(event.getEntity().getMainHandItem(), event.getState(), event.getOriginalSpeed()));
        }
    }

    @SubscribeEvent
    public static void addVanillaTooptips(ItemTooltipEvent event) {
        Item item = event.getItemStack().getItem();
    }

    @SubscribeEvent
    public static void handlePlayerSwing(AttackEntityEvent event) {
        Player player;
        ItemStack stack;
        Item item;
        Player player2 = event.getEntity();
        if (player2 instanceof Player && (item = (stack = (player = player2).getMainHandItem()).getItem()) instanceof JSwordItem) {
            JSwordItem sword = (JSwordItem)item;
            if (player.getAttackStrengthScale(0.5f) > 0.9f && !player.isSprinting() && player.onGround()) {
                sword.getAbility().onSweep(stack, event.getTarget(), player);
            }
        }
    }

    public static void onKeyPressed(Player player) {
        PlayerArmor playerArmor;
        FullArmorAbility armor;
        if (player != null && (armor = (playerArmor = (PlayerArmor)player.getData(JDataAttachments.PLAYER_ARMOR)).getFullArmor()) != null) {
            armor.keyPressed(player);
        }
    }

    @SubscribeEvent
    public static void equipmentChange(LivingEquipmentChangeEvent event) {
        Item item = event.getFrom().getItem();
        LivingEntity entity = event.getEntity();
        EquipmentSlot slot = event.getSlot();
        if (item instanceof JGear) {
            ((JGear)item).getAbility().unEquip(entity, slot, event.getFrom());
        }
        if ((item = event.getTo().getItem()) instanceof JGear) {
            ((JGear)item).getAbility().equip(entity, slot, event.getTo());
        }
        if (slot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR) {
            PlayerArmor armor = (PlayerArmor)event.getEntity().getData(JDataAttachments.PLAYER_ARMOR);
            for (EquipmentSlot equipmentSlot : EquipmentSlotGroup.ARMOR) {
                Set<ItemStack> current = Collections.singleton(entity.getItemBySlot(equipmentSlot));
                armor.setArmor(current.iterator());
            }
        }
    }
}

