/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.event;

import java.util.Objects;
import net.jitl.common.capability.essence.PlayerEssence;
import net.jitl.common.capability.gear.PlayerArmor;
import net.jitl.common.capability.keypressed.PressedKeyCap;
import net.jitl.common.capability.player.CelestiumArmorAbility;
import net.jitl.common.capability.player.ItemCooldown;
import net.jitl.common.capability.player.Portal;
import net.jitl.common.capability.stats.PlayerStats;
import net.jitl.common.world.dimension.Dimensions;
import net.jitl.core.init.internal.JAttributes;
import net.jitl.core.init.internal.JDataAttachments;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="jitl")
public class ModEvents {
    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            ((PlayerStats)event.getEntity().getData(JDataAttachments.PLAYER_STATS)).copyFrom((PlayerStats)event.getOriginal().getData(JDataAttachments.PLAYER_STATS));
            ((PlayerEssence)event.getEntity().getData(JDataAttachments.ESSENCE)).copyFrom((PlayerEssence)event.getOriginal().getData(JDataAttachments.ESSENCE));
            ((PressedKeyCap)event.getEntity().getData(JDataAttachments.KEY_PRESSED)).copyFrom((PressedKeyCap)event.getOriginal().getData(JDataAttachments.KEY_PRESSED));
            ((PlayerArmor)event.getEntity().getData(JDataAttachments.PLAYER_ARMOR)).copyFrom((PlayerArmor)event.getOriginal().getData(JDataAttachments.PLAYER_ARMOR));
            ((Portal)event.getEntity().getData(JDataAttachments.PORTAL_OVERLAY)).copyFrom((Portal)event.getOriginal().getData(JDataAttachments.PORTAL_OVERLAY));
            ((CelestiumArmorAbility)event.getEntity().getData(JDataAttachments.CELESTIUM_ARMOR)).copyFrom((CelestiumArmorAbility)event.getOriginal().getData(JDataAttachments.CELESTIUM_ARMOR));
            ((ItemCooldown)event.getEntity().getData(JDataAttachments.ITEM_COOLDOWN)).copyFrom((ItemCooldown)event.getOriginal().getData(JDataAttachments.ITEM_COOLDOWN));
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof Player) {
            Player player2 = player;
            PlayerStats stats = (PlayerStats)player2.getData(JDataAttachments.PLAYER_STATS);
            stats.update(player2);
            Portal portal = (Portal)player2.getData(JDataAttachments.PORTAL_OVERLAY);
            portal.serverTick();
            PlayerEssence essence = (PlayerEssence)player2.getData(JDataAttachments.ESSENCE);
            if (essence.isRegenReady()) {
                essence.addEssence(player2, (float)Objects.requireNonNull(player2.getAttribute(JAttributes.ESSENCE_REGEN_SPEED)).getValue());
            } else {
                essence.setBurnout(essence.getBurnout() - 0.1f);
            }
            essence.sendPacket(player2);
            Level level = player2.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (player2.getY() <= (double)serverLevel.getMinY()) {
                    if (serverLevel.dimension() == Dimensions.EUCA) {
                        ModEvents.entityFell(player2, Dimensions.OVERWORLD);
                    }
                    if (serverLevel.dimension() == Dimensions.CLOUDIA) {
                        ModEvents.entityFell(player2, Dimensions.TERRANIA);
                    }
                }
            }
        }
    }

    private static void entityFell(Player entity, ResourceKey<Level> to) {
        ServerLevel destination;
        Level serverLevel = entity.level();
        MinecraftServer minecraftserver = serverLevel.getServer();
        if (minecraftserver != null && (destination = minecraftserver.getLevel(to)) != null) {
            entity.setPortalCooldown();
            TeleportTransition transition = new TeleportTransition(destination, new Vec3(entity.getX(), (double)((float)destination.getMaxY() - entity.getBbHeight()), entity.getZ()), entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), TeleportTransition.DO_NOTHING);
            entity.teleport(transition);
            entity.displayClientMessage((Component)Component.translatable((String)"jitl.death_pos", (Object[])new Object[]{(int)entity.getX(), (int)entity.getZ()}), false);
        }
    }
}

