/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items;

import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.block.JChestBlock;
import net.jitl.common.capability.stats.PlayerStats;
import net.jitl.common.items.base.JItem;
import net.jitl.core.init.internal.JBlocks;
import net.jitl.core.init.internal.JDataAttachments;
import net.jitl.core.init.internal.JItems;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class ChestInteractionItem
extends JItem {
    public ChestInteractionItem(Item.Properties p) {
        super(p.stacksTo(16));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Player player = context.getPlayer();
        assert (player != null);
        ItemStack heldItem = player.getMainHandItem();
        Level world = context.getLevel();
        BlockState blockstate = world.getBlockState(pos = context.getClickedPos());
        if (blockstate.getBlock() instanceof JChestBlock) {
            this.unlockChest(player, EnumKnowledge.OVERWORLD, (Item)JItems.CHEST_KEY.get(), world, pos, (Block)JBlocks.BOIL_CHEST.get(), (Block)JBlocks.EUCA_CHEST.get(), (Block)JBlocks.FROZEN_CHEST.get(), (Block)JBlocks.NETHER_CHEST.get(), (Block)JBlocks.JOURNEY_CHEST.get(), (Block)JBlocks.DEPTHS_CHEST.get(), (Block)JBlocks.CORBA_CHEST.get(), (Block)JBlocks.TERRANIAN_CHEST.get(), (Block)JBlocks.CLOUDIA_CHEST.get(), (Block)JBlocks.SENTERIAN_CHEST.get());
            this.unlockChest(player, EnumKnowledge.BOIL, (Item)JItems.BOILING_KEY.get(), world, pos, (Block)JBlocks.BOIL_CHEST.get());
            this.unlockChest(player, EnumKnowledge.EUCA, (Item)JItems.EUCA_KEY.get(), world, pos, (Block)JBlocks.EUCA_CHEST.get());
            this.unlockChest(player, EnumKnowledge.FROZEN, (Item)JItems.FROZEN_KEY.get(), world, pos, (Block)JBlocks.FROZEN_CHEST.get());
            this.unlockChest(player, EnumKnowledge.NETHER, (Item)JItems.NETHER_KEY.get(), world, pos, (Block)JBlocks.NETHER_CHEST.get());
            this.unlockChest(player, EnumKnowledge.OVERWORLD, (Item)JItems.JOURNEY_KEY.get(), world, pos, (Block)JBlocks.JOURNEY_CHEST.get());
            this.unlockChest(player, EnumKnowledge.DEPTHS, (Item)JItems.DEPTHS_CHEST_KEY.get(), world, pos, (Block)JBlocks.DEPTHS_CHEST.get());
            this.unlockChest(player, EnumKnowledge.CORBA, (Item)JItems.CORBA_KEY.get(), world, pos, (Block)JBlocks.CORBA_CHEST.get());
            this.unlockChest(player, EnumKnowledge.TERRANIA, (Item)JItems.TERRANIAN_KEY.get(), world, pos, (Block)JBlocks.TERRANIAN_CHEST.get());
            this.unlockChest(player, EnumKnowledge.CLOUDIA, (Item)JItems.CLOUDIA_KEY.get(), world, pos, (Block)JBlocks.CLOUDIA_CHEST.get());
            this.unlockChest(player, EnumKnowledge.SENTERIAN, (Item)JItems.SENTERIAN_KEY.get(), world, pos, (Block)JBlocks.SENTERIAN_CHEST.get());
            if (heldItem.getItem() == JItems.PADLOCK.get()) {
                this.lockChest(player, world, pos);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void lockChest(Player player, Level world, BlockPos pos) {
        BlockState clickedChest = world.getBlockState(pos);
        Block chest = clickedChest.getBlock();
        if (world.getBlockState(pos).getBlock() == chest) {
            boolean isWest;
            BlockState n = world.getBlockState(pos.north());
            BlockState s = world.getBlockState(pos.south());
            BlockState e = world.getBlockState(pos.east());
            BlockState w = world.getBlockState(pos.west());
            boolean isNorth = n.getBlock() == chest;
            boolean isSouth = s.getBlock() == chest;
            boolean isEast = e.getBlock() == chest;
            boolean bl = isWest = w.getBlock() == chest;
            if (!((Boolean)clickedChest.getValue((Property)JChestBlock.IS_LOCKED)).booleanValue()) {
                world.setBlock(pos, (BlockState)clickedChest.setValue((Property)JChestBlock.IS_LOCKED, (Comparable)Boolean.TRUE), 2);
                if (isNorth) {
                    world.setBlock(pos.north(), (BlockState)n.setValue((Property)JChestBlock.IS_LOCKED, (Comparable)Boolean.TRUE), 2);
                }
                if (isSouth) {
                    world.setBlock(pos.south(), (BlockState)s.setValue((Property)JChestBlock.IS_LOCKED, (Comparable)Boolean.TRUE), 2);
                }
                if (isEast) {
                    world.setBlock(pos.east(), (BlockState)e.setValue((Property)JChestBlock.IS_LOCKED, (Comparable)Boolean.TRUE), 2);
                }
                if (isWest) {
                    world.setBlock(pos.west(), (BlockState)w.setValue((Property)JChestBlock.IS_LOCKED, (Comparable)Boolean.TRUE), 2);
                }
                player.getMainHandItem().shrink(1);
                world.playSound(null, pos, SoundEvents.IRON_DOOR_CLOSE, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public void unlockChest(Player player, EnumKnowledge knowledge, Item key, Level world, BlockPos pos, Block ... c) {
        for (Block chest : c) {
            if (player.getMainHandItem().getItem() != key || world.getBlockState(pos).getBlock() != chest) continue;
            BlockState n = world.getBlockState(pos.north());
            BlockState s = world.getBlockState(pos.south());
            BlockState e = world.getBlockState(pos.east());
            BlockState w = world.getBlockState(pos.west());
            boolean isNorth = n.getBlock() == chest;
            boolean isSouth = s.getBlock() == chest;
            boolean isEast = e.getBlock() == chest;
            boolean isWest = w.getBlock() == chest;
            BlockState clickedChest = world.getBlockState(pos);
            if (!((Boolean)clickedChest.getValue((Property)JChestBlock.IS_LOCKED)).booleanValue()) continue;
            world.setBlock(pos, (BlockState)clickedChest.setValue((Property)JChestBlock.IS_LOCKED, (Comparable)Boolean.FALSE), 2);
            if (isNorth) {
                world.setBlock(pos.north(), (BlockState)n.setValue((Property)JChestBlock.IS_LOCKED, (Comparable)Boolean.FALSE), 2);
            }
            if (isSouth) {
                world.setBlock(pos.south(), (BlockState)s.setValue((Property)JChestBlock.IS_LOCKED, (Comparable)Boolean.FALSE), 2);
            }
            if (isEast) {
                world.setBlock(pos.east(), (BlockState)e.setValue((Property)JChestBlock.IS_LOCKED, (Comparable)Boolean.FALSE), 2);
            }
            if (isWest) {
                world.setBlock(pos.west(), (BlockState)w.setValue((Property)JChestBlock.IS_LOCKED, (Comparable)Boolean.FALSE), 2);
            }
            player.getMainHandItem().shrink(1);
            world.playSound(null, pos, SoundEvents.IRON_DOOR_OPEN, SoundSource.BLOCKS, 1.0f, 1.0f);
            ((PlayerStats)player.getData(JDataAttachments.PLAYER_STATS)).addXP(knowledge, 10.0f, player);
        }
    }

    public void checkSpecificKeyToChest(Player player, Item key, Block chest, BlockState blockstate, Level world, BlockPos pos) {
        if (player.getMainHandItem().getItem() == key && blockstate.getBlock() == chest && ((Boolean)blockstate.getValue((Property)JChestBlock.IS_LOCKED)).booleanValue()) {
            BlockState s = (BlockState)blockstate.setValue((Property)JChestBlock.IS_LOCKED, (Comparable)Boolean.FALSE);
            world.setBlock(pos, s, 2);
            player.getMainHandItem().shrink(1);
            world.playSound(null, pos, SoundEvents.IRON_DOOR_OPEN, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }
}

