/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.client.util.ClientTools;
import net.jitl.client.util.ClientUtils;
import net.jitl.client.util.EnumHexColor;
import net.jitl.common.capability.player.LoreScroll;
import net.jitl.common.capability.stats.PlayerStats;
import net.jitl.common.items.base.JItem;
import net.jitl.common.scroll.ScrollAPI;
import net.jitl.common.scroll.ScrollEntry;
import net.jitl.core.init.JITL;
import net.jitl.core.init.internal.JDataAttachments;
import net.jitl.core.init.internal.JDataComponents;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class LoreScrollItem
extends JItem {
    public LoreScrollItem(Item.Properties p) {
        super(p.stacksTo(1));
    }

    @NotNull
    public InteractionResult use(@NotNull Level worldIn, @NotNull Player playerIn, @NotNull InteractionHand handIn) {
        ItemStack heldItem = playerIn.getItemInHand(handIn);
        ScrollEntry entry = LoreScrollItem.getScrollEntry(heldItem);
        LoreScroll scroll = (LoreScroll)heldItem.get(JDataComponents.SCROLL);
        PlayerStats stats = (PlayerStats)playerIn.getData(JDataAttachments.PLAYER_STATS);
        if (entry != null && scroll != null) {
            if (!worldIn.isClientSide()) {
                if (!scroll.openedBefore()) {
                    if (scroll.knowledge() != null) {
                        stats.addLevel(EnumKnowledge.byName(scroll.knowledge()), scroll.level());
                    }
                    heldItem.set(JDataComponents.SCROLL, (Object)new LoreScroll(scroll.entry(), scroll.knowledge(), scroll.level(), true));
                }
            } else {
                ClientTools.playLocalSound(SoundEvents.BOOK_PAGE_TURN, 1.0f, 1.0f);
                ClientUtils.displayScrollGui(entry);
                if (!scroll.openedBefore() && scroll.knowledge() != null) {
                    ClientUtils.displayToast(scroll);
                }
            }
        } else if (!worldIn.isClientSide()) {
            MutableComponent msg = Component.translatable((String)"scroll.jitl.fail");
            msg.withStyle(ChatFormatting.RED);
            playerIn.displayClientMessage((Component)msg, false);
        }
        return InteractionResult.SUCCESS;
    }

    public static void bindScrollEntry(ItemStack stack, ScrollEntry entry, EnumKnowledge knowledge, int level) {
        if (stack.getItem() instanceof LoreScrollItem) {
            stack.set(JDataComponents.SCROLL, (Object)new LoreScroll(entry.getId(), knowledge.getName(), level, false));
        } else {
            JITL.LOGGER.error("Provided stack param is not of {}", LoreScrollItem.class, (Object)new IllegalArgumentException());
        }
    }

    public static void bindScrollEntry(ItemStack stack, ScrollEntry entry) {
        if (stack.getItem() instanceof LoreScrollItem) {
            stack.set(JDataComponents.SCROLL, (Object)new LoreScroll(entry.getId(), null, 0, false));
        } else {
            JITL.LOGGER.error("Provided stack param is not of {}", LoreScrollItem.class, (Object)new IllegalArgumentException());
        }
    }

    @Nullable
    public static ScrollEntry getScrollEntry(ItemStack stack) {
        LoreScroll scroll = (LoreScroll)stack.get(JDataComponents.SCROLL);
        if (stack.getItem() instanceof LoreScrollItem) {
            if (scroll != null) {
                String id = scroll.entry();
                return ScrollAPI.getEntry(id);
            }
        } else {
            JITL.LOGGER.error("Provided stack param is not an {}", LoreScrollItem.class, (Object)new IllegalArgumentException());
        }
        return null;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext pContext, TooltipDisplay display, Consumer<Component> list, TooltipFlag pTooltipFlag) {
        MutableComponent overworld = Component.translatable((String)"scroll.jitl.chapter.one").setStyle(Style.EMPTY.withColor(ChatFormatting.AQUA));
        MutableComponent nether = Component.translatable((String)"scroll.jitl.chapter.two").setStyle(Style.EMPTY.withColor(ChatFormatting.RED));
        MutableComponent end = Component.translatable((String)"scroll.jitl.chapter.three").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_PURPLE));
        MutableComponent boil = Component.translatable((String)"scroll.jitl.chapter.four").setStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW));
        MutableComponent frozen = Component.translatable((String)"scroll.jitl.chapter.five").setStyle(Style.EMPTY.withColor(EnumHexColor.TURQUOISE.getInt()));
        MutableComponent euca = Component.translatable((String)"scroll.jitl.chapter.six").setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD));
        MutableComponent depths = Component.translatable((String)"scroll.jitl.chapter.seven").setStyle(Style.EMPTY.withColor(ChatFormatting.BLUE));
        MutableComponent corba = Component.translatable((String)"scroll.jitl.chapter.eight").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GREEN));
        MutableComponent terrania = Component.translatable((String)"scroll.jitl.chapter.nine").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_PURPLE));
        MutableComponent cloudia = Component.translatable((String)"scroll.jitl.chapter.ten").setStyle(Style.EMPTY.withColor(ChatFormatting.LIGHT_PURPLE));
        MutableComponent senterian = Component.translatable((String)"scroll.jitl.chapter.eleven").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY));
        LoreScroll scroll = (LoreScroll)stack.get(JDataComponents.SCROLL);
        if (scroll != null) {
            if (scroll.entry().contains("my_last_words")) {
                list.accept((Component)overworld);
                list.accept((Component)Component.translatable((String)"scroll.jitl.name.my_last_words").setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)));
            }
            if (scroll.entry().contains("netheric_status")) {
                list.accept((Component)nether);
                list.accept((Component)Component.translatable((String)"scroll.jitl.name.netheric_status").setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)));
            }
            if (scroll.entry().contains("the_end")) {
                list.accept((Component)end);
                list.accept((Component)Component.translatable((String)"scroll.jitl.name.the_end").setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)));
            }
            if (scroll.entry().contains("beyond_boiling")) {
                list.accept((Component)boil);
                list.accept((Component)Component.translatable((String)"scroll.jitl.name.beyond_boiling").setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)));
            }
            if (scroll.entry().contains("frozen_despair")) {
                list.accept((Component)frozen);
                list.accept((Component)Component.translatable((String)"scroll.jitl.name.frozen_despair").setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)));
            }
            if (scroll.entry().contains("the_royals")) {
                list.accept((Component)euca);
                list.accept((Component)Component.translatable((String)"scroll.jitl.name.the_royals").setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)));
            }
            if (scroll.entry().contains("darkness")) {
                list.accept((Component)depths);
                list.accept((Component)Component.translatable((String)"scroll.jitl.name.darkness").setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)));
            }
            if (scroll.entry().contains("senterian_gospel")) {
                list.accept((Component)corba);
                list.accept((Component)Component.translatable((String)"scroll.jitl.name.sentry_gospel").setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)));
            }
            if (scroll.entry().contains("fungi")) {
                list.accept((Component)terrania);
                list.accept((Component)Component.translatable((String)"scroll.jitl.name.fungi").setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)));
            }
            if (scroll.entry().contains("mist")) {
                list.accept((Component)cloudia);
                list.accept((Component)Component.translatable((String)"scroll.jitl.name.mist").setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)));
            }
            if (scroll.entry().contains("this_is_it")) {
                list.accept((Component)senterian);
                list.accept((Component)Component.translatable((String)"scroll.jitl.name.this_is_it").setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)));
            }
        }
    }
}

