/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items;

import java.util.function.Consumer;
import net.jitl.common.capability.essence.PlayerEssence;
import net.jitl.common.entity.projectile.JThrowableProjectile;
import net.jitl.common.items.base.JItem;
import net.jitl.core.helper.IEssenceItem;
import net.jitl.core.helper.TriFunction;
import net.jitl.core.init.internal.JDataAttachments;
import net.jitl.core.init.internal.JItems;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class StaffItem
extends JItem
implements IEssenceItem {
    protected TriFunction<Integer, Level, LivingEntity, JThrowableProjectile> projectileFactory;
    private final int essenceUsage;
    private final int damage;

    public StaffItem(Item.Properties p, int essence, int damage, int maxUses, TriFunction<Integer, Level, LivingEntity, JThrowableProjectile> projectileFactory) {
        super(p.stacksTo(1).durability(maxUses));
        this.projectileFactory = projectileFactory;
        this.essenceUsage = essence;
        this.damage = damage;
    }

    @NotNull
    public InteractionResult use(@NotNull Level level, Player player, @NotNull InteractionHand usedHand) {
        if (!level.isClientSide() && ((PlayerEssence)player.getData(JDataAttachments.ESSENCE)).consumeEssence(player, this.essenceUsage)) {
            JThrowableProjectile projectile = this.projectileFactory.apply(this.damage, level, (LivingEntity)player);
            projectile.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
            level.addFreshEntity((Entity)projectile);
            projectile.setPos(player.getX(), player.getEyeY(), player.getZ());
            player.getItemInHand(usedHand).hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)JSounds.STAFF_0.get(), SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext pContext, TooltipDisplay display, Consumer<Component> tooltip, TooltipFlag pTooltipFlag) {
        tooltip.accept((Component)Component.translatable((String)"jitl.tooltip.staff", (Object[])new Object[]{this.damage / 2}));
        this.addItemDesc(JItems.STAFF_OF_CONJURING.asItem(), tooltip, "jitl.tooltip.staff_of_conjuring");
        this.addItemDesc(JItems.STAFF_OF_ESSENCIA.asItem(), tooltip, "jitl.tooltip.staff_of_essencia");
        this.addItemDesc(JItems.STAFF_OF_HELLSTONE.asItem(), tooltip, "jitl.tooltip.staff_of_hellstone");
        this.addItemDesc(JItems.DOOMSBRINGER.asItem(), tooltip, "jitl.tooltip.doomsbringer");
        this.addItemDesc(JItems.OVERGROWN_STAFF.asItem(), tooltip, "jitl.tooltip.overgrown_staff");
        this.addItemDesc(JItems.STAFF_OF_DIVINITY.asItem(), tooltip, "jitl.tooltip.staff_of_divinity");
        this.addItemDesc(JItems.STAFF_OF_ENLIGHTENMENT.asItem(), tooltip, "jitl.tooltip.staff_of_enlightenment");
        this.addItemDesc(JItems.CRYSTAL_STAFF.asItem(), tooltip, "jitl.tooltip.crystal_staff");
        this.addItemDesc(JItems.STAFF_OF_GREENPACE.asItem(), tooltip, "jitl.tooltip.staff_of_greenpace");
        tooltip.accept((Component)Component.translatable((String)"jitl.tooltip.essence_usage", (Object[])new Object[]{this.essenceUsage}));
        tooltip.accept((Component)Component.translatable((String)"jitl.uses_remaining", (Object[])new Object[]{stack.getMaxDamage() - stack.getDamageValue()}));
    }
}

