/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items;

import java.util.function.Consumer;
import net.jitl.common.capability.essence.PlayerEssence;
import net.jitl.common.items.base.JItem;
import net.jitl.core.helper.IEssenceItem;
import net.jitl.core.helper.MathHelper;
import net.jitl.core.init.internal.JDataAttachments;
import net.jitl.core.init.internal.JItems;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.NotNull;

public class TeleportItem
extends JItem
implements IEssenceItem {
    private final int essenceUsage;

    public TeleportItem(Item.Properties p, int essence, int maxUses) {
        super(p.stacksTo(1).durability(maxUses));
        this.essenceUsage = essence;
    }

    @NotNull
    public InteractionResult use(@NotNull Level level, Player player, @NotNull InteractionHand usedHand) {
        float var18;
        float var16;
        double var19;
        float var15;
        float var4 = player.getXRot();
        float var5 = player.getYRot();
        double var6 = player.getX();
        double var8 = player.getY() + 1.62;
        double var10 = player.getZ();
        Vec3 var12 = new Vec3(var6, var8, var10);
        float var13 = MathHelper.cos(-var5 * 0.01745329f - (float)Math.PI);
        float var14 = MathHelper.sin(-var5 * 0.01745329f - (float)Math.PI);
        float var17 = var14 * (var15 = -MathHelper.cos(-var4 * 0.01745329f));
        Vec3 var21 = var12.add((double)var17 * (var19 = 30.0), (double)(var16 = MathHelper.sin(-var4 * 0.01745329f)) * var19, (double)(var18 = var13 * var15) * var19);
        BlockHitResult var22 = level.clip(new ClipContext(var12, var21, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, CollisionContext.empty()));
        if (var22 == null) {
            return InteractionResult.FAIL;
        }
        int var23 = var22.getBlockPos().getX();
        int var24 = var22.getBlockPos().getY();
        int var25 = var22.getBlockPos().getZ();
        Direction var26 = var22.getDirection();
        if (var26 == Direction.DOWN) {
            --var24;
        }
        if (var26 == Direction.UP) {
            ++var24;
        }
        if (var26 == Direction.NORTH) {
            --var25;
        }
        if (var26 == Direction.SOUTH) {
            ++var25;
        }
        if (var26 == Direction.WEST) {
            --var23;
        }
        if (var26 == Direction.EAST) {
            ++var23;
        }
        if (!level.isClientSide() && ((PlayerEssence)player.getData(JDataAttachments.ESSENCE)).consumeEssence(player, this.essenceUsage)) {
            this.teleportTo((ServerPlayer)player, level, var23, var24 + 1, var25);
            player.getItemInHand(usedHand).hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
        }
        return InteractionResult.SUCCESS;
    }

    protected void teleportTo(ServerPlayer player, Level level, int x, int y, int z) {
        player.teleportTo((double)x, (double)y, (double)z);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext pContext, TooltipDisplay display, Consumer<Component> tooltip, TooltipFlag pTooltipFlag) {
        this.addItemDesc(JItems.TELEPORTATION_STAFF.asItem(), tooltip, "jitl.tooltip.teleport");
        tooltip.accept((Component)Component.translatable((String)"jitl.tooltip.essence_usage", (Object[])new Object[]{this.essenceUsage}));
    }
}

