/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items.base;

import java.util.function.Consumer;
import net.jitl.common.items.base.JItem;
import net.jitl.common.items.gear.IAbility;
import net.jitl.common.items.gear.JGear;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import org.jetbrains.annotations.Nullable;

public class JArmorItem
extends JItem
implements JGear {
    private final IAbility ability;
    private final ArmorMaterial material;

    public JArmorItem(Item.Properties p, ArmorMaterial pMaterial, ArmorType pSlot, IAbility ability) {
        super(p.stacksTo(1).humanoidArmor(pMaterial, pSlot));
        this.ability = ability;
        this.material = pMaterial;
    }

    public ArmorMaterial getMaterial() {
        return this.material;
    }

    @Override
    @Nullable
    public IAbility getAbility() {
        if (this.ability == null) {
            return new IAbility(this){};
        }
        return this.ability;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext pContext, TooltipDisplay display, Consumer<Component> tooltip, TooltipFlag pTooltipFlag) {
        super.appendHoverText(stack, pContext, display, tooltip, pTooltipFlag);
        if (this.ability != null) {
            this.ability.fillTooltips(stack, tooltip);
        }
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return true;
    }
}

