/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items.base;

import java.util.function.Consumer;
import net.jitl.common.items.gear.IAbility;
import net.jitl.common.items.gear.JGear;
import net.jitl.core.helper.JToolTiers;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;

public class JHoeItem
extends HoeItem
implements JGear {
    private final IAbility ability;

    public JHoeItem(Item.Properties p, JToolTiers tier, int dam, IAbility ability) {
        super(tier.getTier(), (float)dam, tier.getSpeedModifier(), p);
        this.ability = ability;
    }

    @Override
    public IAbility getAbility() {
        return this.ability;
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        this.ability.rightClick(player, hand, level);
        return super.use(level, player, hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext pContext, TooltipDisplay display, Consumer<Component> tooltip, TooltipFlag pTooltipFlag) {
        super.appendHoverText(stack, pContext, display, tooltip, pTooltipFlag);
        this.ability.fillTooltips(stack, tooltip);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return this.ability.animate(super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged), oldStack, newStack, slotChanged);
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return this.ability.resetBreak(super.shouldCauseBlockBreakReset(oldStack, newStack), oldStack, newStack);
    }
}

