/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items.curios;

import java.util.Objects;
import java.util.function.Consumer;
import net.jitl.common.items.base.JItem;
import net.jitl.core.helper.TooltipFiller;
import net.jitl.core.init.JITL;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;

public class JCurioItem
extends JItem {
    private boolean hasOverview;
    private boolean hasAbility;
    private boolean hasNegativeEffects;

    public JCurioItem(Item.Properties properties) {
        super(properties);
    }

    public JCurioItem overview(boolean hasOverview) {
        this.hasOverview = hasOverview;
        return this;
    }

    public JCurioItem ability(boolean hasAbility) {
        this.hasAbility = hasAbility;
        return this;
    }

    public JCurioItem drawback(boolean hasNegativeEffects) {
        this.hasNegativeEffects = hasNegativeEffects;
        return this;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext pContext, TooltipDisplay display, Consumer<Component> tip, TooltipFlag pTooltipFlag) {
        super.appendHoverText(stack, pContext, display, tip, pTooltipFlag);
        TooltipFiller tooltipFiller = new TooltipFiller(tip, Objects.requireNonNull(JITL.getRegistryName(this)).getPath());
        if (this.hasOverview) {
            tooltipFiller.addOverview();
        }
        if (this.hasAbility) {
            tooltipFiller.addDetail();
        }
        if (this.hasNegativeEffects) {
            tooltipFiller.addDrawback();
        }
    }
}

