/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.scroll;

import java.util.LinkedHashMap;
import net.jitl.common.scroll.ScrollEntry;
import net.minecraft.resources.ResourceLocation;

public class ScrollCategory {
    private final int categorySize;
    private final String categoryKey;
    private final ResourceLocation backgroundTexture;
    private final String id;
    private final LinkedHashMap<String, ScrollEntry> entryList = new LinkedHashMap();

    public ScrollCategory(String categoryKey, ResourceLocation backgroundTexture) {
        this(categoryKey, backgroundTexture, 2);
    }

    public ScrollCategory(String categoryKey, ResourceLocation backgroundTexture, int categorySize) {
        this.categorySize = categorySize;
        this.categoryKey = categoryKey;
        this.backgroundTexture = backgroundTexture;
        this.id = this.categoryKey.toUpperCase().replace(' ', '_');
    }

    public int getCategorySize() {
        return this.categorySize;
    }

    public String getCategoryKey() {
        return this.categoryKey;
    }

    public LinkedHashMap<String, ScrollEntry> getEntryList() {
        return this.entryList;
    }

    public void addEntryToCategory(ScrollEntry ScrollEntry2) {
        this.entryList.put(ScrollEntry2.getId(), ScrollEntry2);
    }

    public ScrollEntry getEntry(String entryID) {
        if (!this.entryList.containsKey(entryID)) {
            throw new IndexOutOfBoundsException("Attempt to get nonexistent Entry \"" + entryID + "\" in \"" + this.categoryKey + "\" Category.\n\tAvailable Entry Names: " + this.entryList.toString());
        }
        return this.entryList.get(entryID);
    }

    public ResourceLocation getBackgroundTexture() {
        return this.backgroundTexture;
    }

    public String getId() {
        return this.id;
    }

    public int getEntryCount() {
        return this.entryList.size();
    }
}

