/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.scroll;

import java.util.ArrayList;
import java.util.List;
import net.jitl.common.scroll.IDescComponent;
import net.jitl.common.scroll.ScrollEntry;
import net.jitl.common.scroll.TextDescComponent;
import net.minecraft.world.item.ItemStack;

public class ScrollEntryBuilder {
    private final String id;
    private final String titleKey;
    private final String commentKey;
    private final ItemStack displayedItem;
    private final List<IDescComponent> pageContent = new ArrayList<IDescComponent>();
    private final int x;
    private final int y;

    public ScrollEntryBuilder(String id, String titleKey, String commentKey, ItemStack displayedItem, int x, int y) {
        this.id = id;
        this.titleKey = titleKey;
        this.commentKey = commentKey;
        this.displayedItem = displayedItem;
        this.x = x;
        this.y = y;
    }

    public ScrollEntryBuilder addComponent(IDescComponent component) {
        this.pageContent.add(component);
        return this;
    }

    public ScrollEntryBuilder addTextComponent(String langKey) {
        this.pageContent.add(new TextDescComponent(langKey));
        return this;
    }

    public ScrollEntry build() {
        return new ScrollEntry(this.id, this.titleKey, this.commentKey, this.displayedItem, this.pageContent, this.x, this.y);
    }
}

