/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.world.gen.boil;

import com.mojang.serialization.Codec;
import net.jitl.core.init.internal.JBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class ScorchedStalagmiteFeature
extends Feature<NoneFeatureConfiguration> {
    public ScorchedStalagmiteFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos pos = context.origin();
        WorldGenLevel reader = context.level();
        RandomSource rand = context.random();
        if (reader.getBlockState((pos = reader.getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, pos)).below()) != ((Block)JBlocks.SCORCHED_RUBBLE.get()).defaultBlockState()) {
            return false;
        }
        BlockPos.MutableBlockPos placePos = pos.mutable();
        int xPos = pos.getX();
        int zPos = pos.getZ();
        int yPos = reader.getHeight(Heightmap.Types.WORLD_SURFACE_WG, xPos, zPos);
        placePos.set(xPos, yPos - 1, zPos);
        BlockPos blockPos = reader.getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, pos);
        int bottomHeight = 1 + rand.nextInt(4);
        int largeHeight = 1 + rand.nextInt(5);
        int medHeight = 1 + rand.nextInt(6);
        int smallHeight = 1 + rand.nextInt(7);
        int tinyHeight = 1 + rand.nextInt(8);
        placePos.setWithOffset((Vec3i)blockPos, rand.nextInt(10) + 5, 0, rand.nextInt(10) + 5);
        if (reader.getBlockState(placePos.above()) == Blocks.AIR.defaultBlockState() && reader.getBlockState((BlockPos)placePos) == ((Block)JBlocks.SCORCHED_RUBBLE.get()).defaultBlockState()) {
            int i;
            for (i = 0; i < bottomHeight; ++i) {
                this.setBlock((LevelWriter)reader, (BlockPos)placePos.move(Direction.UP), ((Block)JBlocks.SCORCHED_RUBBLE.get()).defaultBlockState());
            }
            for (i = 0; i < largeHeight; ++i) {
                this.setBlock((LevelWriter)reader, (BlockPos)placePos.move(Direction.UP), ((Block)JBlocks.SCORCHED_STALAGMITE_LARGE.get()).defaultBlockState());
            }
            for (i = 0; i < medHeight; ++i) {
                this.setBlock((LevelWriter)reader, (BlockPos)placePos.move(Direction.UP), ((Block)JBlocks.SCORCHED_STALAGMITE_MED.get()).defaultBlockState());
            }
            for (i = 0; i < smallHeight; ++i) {
                this.setBlock((LevelWriter)reader, (BlockPos)placePos.move(Direction.UP), ((Block)JBlocks.SCORCHED_STALAGMITE_SMALL.get()).defaultBlockState());
            }
            for (i = 0; i < tinyHeight; ++i) {
                this.setBlock((LevelWriter)reader, (BlockPos)placePos.move(Direction.UP), ((Block)JBlocks.SCORCHED_STALAGMITE_TINY.get()).defaultBlockState());
            }
        }
        return true;
    }
}

