/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.world.gen.cloudia;

import net.jitl.core.helper.MathHelper;
import net.jitl.core.init.internal.JBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class CloudiaLand
extends Feature<NoneFeatureConfiguration> {
    private final BlockState stone = ((Block)JBlocks.CLOUDIA_ROCK.get()).defaultBlockState();
    private final int numberOfBlocks;
    private final BlockState replace = Blocks.AIR.defaultBlockState();

    public CloudiaLand() {
        super(NoneFeatureConfiguration.CODEC);
        this.numberOfBlocks = 60;
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel w = context.level();
        RandomSource r = context.random();
        BlockPos pos = context.origin();
        int x1 = pos.getX();
        int y1 = pos.getY();
        int z1 = pos.getZ();
        float f = r.nextFloat() * (float)Math.PI;
        double d0 = (float)(pos.getX() + 8) + MathHelper.sin(f) * (float)this.numberOfBlocks / 8.0f;
        double d1 = (float)(pos.getX() + 8) - MathHelper.sin(f) * (float)this.numberOfBlocks / 8.0f;
        double d2 = (float)(pos.getZ() + 8) + MathHelper.cos(f) * (float)this.numberOfBlocks / 8.0f;
        double d3 = (float)(pos.getZ() + 8) - MathHelper.cos(f) * (float)this.numberOfBlocks / 8.0f;
        double d4 = pos.getY() + r.nextInt(3) - 2;
        double d5 = pos.getY() + r.nextInt(3) - 2;
        for (int i = 0; i < this.numberOfBlocks; ++i) {
            float f1 = (float)i / (float)this.numberOfBlocks;
            double d6 = d0 + (d1 - d0) * (double)f1;
            double d7 = d4 + (d5 - d4) * (double)f1;
            double d8 = d2 + (d3 - d2) * (double)f1;
            double d9 = r.nextDouble() * (double)this.numberOfBlocks / 16.0;
            double d10 = (double)(MathHelper.sin((float)Math.PI * f1) + 1.0f) * d9 + 1.0;
            double d11 = (double)(MathHelper.sin((float)Math.PI * f1) + 1.0f) * d9 + 1.0;
            int j = MathHelper.floor(d6 - d10 / 2.0);
            int k = MathHelper.floor(d7 - d11 / 2.0);
            int l = MathHelper.floor(d8 - d10 / 2.0);
            int i1 = MathHelper.floor(d6 + d10 / 2.0);
            int j1 = MathHelper.floor(d7 + d11 / 2.0);
            int k1 = MathHelper.floor(d8 + d10 / 2.0);
            for (int l1 = j; l1 <= i1; ++l1) {
                double d12 = ((double)l1 + 0.5 - d6) / (d10 / 2.0);
                if (!(d12 * d12 < 1.0)) continue;
                for (int i2 = k; i2 <= j1; ++i2) {
                    double d13 = ((double)i2 + 0.5 - d7) / (d11 / 2.0);
                    if (!(d12 * d12 + d13 * d13 < 1.0)) continue;
                    for (int j2 = l; j2 <= k1; ++j2) {
                        double d14 = ((double)j2 + 0.5 - d8) / (d10 / 2.0);
                        if (!(d12 * d12 + d13 * d13 + d14 * d14 < 1.0)) continue;
                        BlockPos blockpos1 = new BlockPos(l1, i2, j2);
                        int x = blockpos1.getX();
                        int y = blockpos1.getY();
                        int z = blockpos1.getZ();
                        BlockState state = w.getBlockState(blockpos1);
                        if (w.getBlockState(blockpos1).getBlock().defaultBlockState() != this.replace) continue;
                        w.setBlock(new BlockPos(x, y, z), ((Block)JBlocks.CLOUDIA_GRASS.get()).defaultBlockState(), 2);
                        w.setBlock(new BlockPos(x, y - 1, z), ((Block)JBlocks.CLOUDIA_DIRT.get()).defaultBlockState(), 2);
                        w.setBlock(new BlockPos(x, y - 2, z), this.stone, 2);
                        w.setBlock(new BlockPos(x, y - 3, z), this.stone, 2);
                        if (r.nextInt(18) != 0) continue;
                        w.setBlock(blockpos1.below(3), ((Block)JBlocks.LUNITE_ORE.get()).defaultBlockState(), 2);
                    }
                }
            }
        }
        return true;
    }
}

