/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.world.gen.depths;

import com.mojang.serialization.Codec;
import net.jitl.core.init.internal.JBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class DepthsPillarFeature
extends Feature<NoneFeatureConfiguration> {
    public DepthsPillarFeature(Codec<NoneFeatureConfiguration> c) {
        super(c);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos blockpos = context.origin();
        RandomSource randomsource = context.random();
        if (!level.isEmptyBlock(blockpos)) {
            return false;
        }
        BlockState blockstate = level.getBlockState(blockpos.below());
        if (!blockstate.is((Block)JBlocks.DEPTHS_GRASS.get()) && level.getBlockState(blockpos).is(Blocks.AIR)) {
            return false;
        }
        int x = blockpos.getX();
        int y = blockpos.getY();
        int z = blockpos.getZ();
        int width = randomsource.nextInt(4) + 10;
        int height = 100;
        if (y < 24) {
            for (int j = 0; j < height; ++j) {
                this.placeCircle(level, x, j + y, z, Math.abs(height / 2 - j) / 5 + width);
            }
        }
        return true;
    }

    public void placeCircle(WorldGenLevel w, int x, int y, int z, int r) {
        if (r >= 17) {
            r = 10;
        }
        float i = 0.0f;
        while (i < (float)r) {
            float j = 0.0f;
            while ((double)j < Math.PI * 2 * (double)i) {
                w.setBlock(new BlockPos((int)Math.floor((double)x + Math.sin(j) * (double)i), y, (int)Math.floor((double)z + Math.cos(j) * (double)i)), ((Block)JBlocks.DEPTHS_STONE.get()).defaultBlockState(), 2);
                j = (float)((double)j + 0.5);
            }
            i = (float)((double)i + 0.5);
        }
    }
}

