/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.world.gen.tree_grower.decorators;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.jitl.common.block.base.AttachedBlock;
import net.jitl.common.world.gen.JTreeDecorators;
import net.jitl.core.init.internal.JBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import org.jetbrains.annotations.NotNull;

public class CorbaSwampTreeDecorator
extends TreeDecorator {
    public static final MapCodec<CorbaSwampTreeDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(CorbaSwampTreeDecorator::new, decorator -> Float.valueOf(decorator.probability));
    private final float probability;

    public CorbaSwampTreeDecorator(float float_) {
        this.probability = float_;
    }

    @NotNull
    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)JTreeDecorators.CORBA_SWAMP_DECORATOR.get();
    }

    public void place(TreeDecorator.Context context) {
        RandomSource random = context.random();
        if (!(random.nextFloat() >= this.probability)) {
            int i = ((BlockPos)context.leaves().get(0)).getY();
            context.leaves().stream().filter(blockPos_ -> blockPos_.getY() - i <= 16).forEach(blockPos1_ -> {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    Direction direction1;
                    BlockPos blockpos;
                    if (!(random.nextFloat() <= 0.25f) || !context.isAir(blockpos = blockPos1_.offset((direction1 = direction.getOpposite()).getStepX(), 0, direction1.getStepZ()))) continue;
                    BlockState blockstate = (BlockState)((Block)JBlocks.FUNGAL_SHELF.get()).defaultBlockState().setValue(AttachedBlock.FACING, (Comparable)direction.getOpposite());
                    context.setBlock(blockpos, blockstate);
                }
            });
        }
    }
}

