/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.data;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.jitl.core.data.BasicFileGenerator;
import net.jitl.core.init.internal.JEntities;
import net.jitl.core.init.internal.JItems;

public class JItemGenerator
extends BasicFileGenerator {
    protected BufferedWriter itemModelWriter;

    public void generate() {
        File itemModel;
        String itemModelDir;
        for (String string : JItems.itemName) {
            itemModelDir = "../src/main/resources/assets/jitl/models/item/" + string + ".json";
            itemModel = new File(itemModelDir);
            itemModel.mkdirs();
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getNormalItem("jitl", string, JItems.ItemType.ITEM);
            this.itemModelInit();
        }
        for (String string : JItems.toolName) {
            itemModelDir = "../src/main/resources/assets/jitl/models/item/" + string + ".json";
            itemModel = new File(itemModelDir);
            itemModel.mkdirs();
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getNormalItem("jitl", string, JItems.ItemType.TOOL);
            this.itemModelInit();
        }
        for (String string : JItems.recordName) {
            itemModelDir = "../src/main/resources/assets/jitl/models/item/" + string + ".json";
            itemModel = new File(itemModelDir);
            itemModel.mkdirs();
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getNormalItem("jitl", string, JItems.ItemType.RECORD);
            this.itemModelInit();
        }
        for (int i = 0; i < JEntities.entityName.size(); ++i) {
            String string = JEntities.entityName.get(i) + "_spawn_egg";
            itemModelDir = "../src/main/resources/assets/jitl/models/item/" + string + ".json";
            itemModel = new File(itemModelDir);
            itemModel.mkdirs();
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getSpawnEggItem("jitl", string);
            this.itemModelInit();
        }
        for (String string : JItems.gunName) {
            itemModelDir = "../src/main/resources/assets/jitl/models/item/" + string + ".json";
            itemModel = new File(itemModelDir);
            itemModel.mkdirs();
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getGunItem("jitl", string);
            this.itemModelInit();
        }
        for (String string : JItems.hammerName) {
            itemModelDir = "../src/main/resources/assets/jitl/models/item/" + string + ".json";
            itemModel = new File(itemModelDir);
            itemModel.mkdirs();
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getHammerItem("jitl", string);
            this.itemModelInit();
        }
        this.generateBasicFile(true, "broken_okoloo_club");
        this.generateBasicFile(true, "sentacoin_bag");
    }

    public void itemModelInit() {
        try {
            this.itemModelWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToItemModelFile(String text) {
        try {
            this.itemModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void getGunItem(String modID, String name) {
        this.writeToItemModelFile("{");
        this.writeToItemModelFile("  \"parent\": \"jitl:item/gun\",");
        this.writeToItemModelFile("  \"textures\": {");
        this.writeToItemModelFile("    \"layer0\": \"" + modID + ":item/" + name + "\"");
        this.writeToItemModelFile("  }");
        this.writeToItemModelFile("}");
        this.generateBasicFile(true, name);
    }

    public void getHammerItem(String modID, String name) {
        this.writeToItemModelFile("{");
        this.writeToItemModelFile("  \"parent\": \"jitl:item/hammer_base\",");
        this.writeToItemModelFile("  \"textures\": {");
        this.writeToItemModelFile("    \"1\": \"" + modID + ":item/" + name + "\"");
        this.writeToItemModelFile("  }");
        this.writeToItemModelFile("}");
        this.generateBasicFile(true, name);
    }

    public void getNormalItem(String modID, String name, JItems.ItemType type) {
        this.writeToItemModelFile("{");
        if (type == JItems.ItemType.TOOL) {
            this.writeToItemModelFile("  \"parent\": \"minecraft:item/handheld\",");
        } else {
            this.writeToItemModelFile("  \"parent\": \"minecraft:item/generated\",");
        }
        String texName = type != JItems.ItemType.RECORD ? name : "record";
        this.writeToItemModelFile("  \"textures\": {");
        this.writeToItemModelFile("    \"layer0\": \"" + modID + ":item/" + texName + "\"");
        this.writeToItemModelFile("  }");
        this.writeToItemModelFile("}");
        this.generateBasicFile(true, name);
    }

    public void getSpawnEggItem(String modID, String name) {
        this.writeToItemModelFile("{");
        this.writeToItemModelFile("  \"parent\": \"minecraft:item/generated\",");
        this.writeToItemModelFile("  \"textures\": {");
        this.writeToItemModelFile("    \"layer0\": \"" + modID + ":item/spawn_eggs/" + name + "\"");
        this.writeToItemModelFile("  }");
        this.writeToItemModelFile("}");
        this.generateBasicFile(true, name);
    }
}

