/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.data.block_generation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.jitl.core.data.BasicFileGenerator;
import net.jitl.core.init.internal.JBlocks;

public class JBlockCampfireGenerator
extends BasicFileGenerator {
    protected BufferedWriter blockModelWriter;
    protected BufferedWriter blockOffModelWriter;
    protected BufferedWriter blockstateWriter;
    protected BufferedWriter itemModelWriter;

    public void generate() {
        for (String name : JBlocks.campfireBlockName) {
            String itemModelDir = "../src/main/resources/assets/jitl/models/item/" + name + ".json";
            String blockModelDir = "../src/main/resources/assets/jitl/models/block/" + name + ".json";
            String blockOffModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_off.json";
            String blockstateDir = "../src/main/resources/assets/jitl/blockstates/" + name + ".json";
            File itemModel = new File(itemModelDir);
            File blockModel = new File(blockModelDir);
            File blockOffModel = new File(blockOffModelDir);
            File blockstateModel = new File(blockstateDir);
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
                if (blockModel.exists()) {
                    blockModel.delete();
                }
                blockModel.createNewFile();
                this.blockModelWriter = new BufferedWriter(new FileWriter(blockModel));
                if (blockOffModel.exists()) {
                    blockOffModel.delete();
                }
                blockOffModel.createNewFile();
                this.blockOffModelWriter = new BufferedWriter(new FileWriter(blockOffModel));
                if (blockstateModel.exists()) {
                    blockstateModel.delete();
                }
                blockstateModel.createNewFile();
                this.blockstateWriter = new BufferedWriter(new FileWriter(blockstateModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getBlockItem("jitl", name);
            this.getBlockModel("jitl", name);
            this.getBlockOffModel("jitl", name);
            this.getBlockstate("jitl", name);
            this.generateBasicFile(true, name);
            this.writerInit();
        }
    }

    public void getBlockItem(String modID, String name) {
        this.writeToItemModelFile("{");
        this.writeToItemModelFile("  \"parent\": \"minecraft:item/generated\",");
        this.writeToItemModelFile("  \"textures\": {");
        this.writeToItemModelFile("      \"layer0\": \"" + modID + ":item/" + name + "\"");
        this.writeToItemModelFile("  }");
        this.writeToItemModelFile("}");
    }

    public void getBlockModel(String modID, String name) {
        this.writeToBlockModelFile(this.blockModelWriter, "{");
        this.writeToBlockModelFile(this.blockModelWriter, "  \"parent\": \"minecraft:block/campfire\",");
        this.writeToBlockModelFile(this.blockModelWriter, "  \"render_type\": \"cutout\",");
        this.writeToBlockModelFile(this.blockModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockModelWriter, "    \"particle\": \"" + modID + ":block/" + name + "_log\",");
        this.writeToBlockModelFile(this.blockModelWriter, "    \"fire\": \"" + modID + ":block/" + name + "_fire\",");
        this.writeToBlockModelFile(this.blockModelWriter, "    \"log\": \"" + modID + ":block/" + name + "_log\",");
        this.writeToBlockModelFile(this.blockModelWriter, "    \"lit_log\": \"" + modID + ":block/" + name + "_log_lit\"");
        this.writeToBlockModelFile(this.blockModelWriter, "  }");
        this.writeToBlockModelFile(this.blockModelWriter, "}");
    }

    public void getBlockOffModel(String modID, String name) {
        this.writeToBlockModelFile(this.blockOffModelWriter, "{");
        this.writeToBlockModelFile(this.blockOffModelWriter, "  \"parent\": \"minecraft:block/campfire_off\",");
        this.writeToBlockModelFile(this.blockOffModelWriter, "  \"render_type\": \"cutout\",");
        this.writeToBlockModelFile(this.blockOffModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockOffModelWriter, "    \"particle\": \"" + modID + ":block/" + name + "_log\",");
        this.writeToBlockModelFile(this.blockOffModelWriter, "    \"log\": \"" + modID + ":block/" + name + "_log\"");
        this.writeToBlockModelFile(this.blockOffModelWriter, "  }");
        this.writeToBlockModelFile(this.blockOffModelWriter, "}");
    }

    public void getBlockstate(String modID, String name) {
        this.writeToBlockstateFile("{");
        this.writeToBlockstateFile("  \"variants\": {");
        this.writeToBlockstateFile("    \"facing=east,lit=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_off\",");
        this.writeToBlockstateFile("        \"y\": 270");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=east,lit=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("        \"y\": 270");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=north,lit=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_off\",");
        this.writeToBlockstateFile("        \"y\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=north,lit=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("        \"y\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=south,lit=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_off\"");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=south,lit=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=west,lit=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_off\",");
        this.writeToBlockstateFile("        \"y\": 90");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=west,lit=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("        \"y\": 90");
        this.writeToBlockstateFile("      }");
        this.writeToBlockstateFile("  }");
        this.writeToBlockstateFile("}");
    }

    public void writerInit() {
        try {
            this.itemModelWriter.close();
            this.blockModelWriter.close();
            this.blockOffModelWriter.close();
            this.blockstateWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToItemModelFile(String text) {
        try {
            this.itemModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockModelFile(BufferedWriter w, String text) {
        try {
            w.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockstateFile(String text) {
        try {
            this.blockstateWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

