/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.data.block_generation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.jitl.core.data.BasicFileGenerator;
import net.jitl.core.init.internal.JBlocks;

public class JRedstoneLampBlockGenerator
extends BasicFileGenerator {
    protected BufferedWriter blockModelWriter;
    protected BufferedWriter blockOnModelWriter;
    protected BufferedWriter blockstateWriter;
    protected BufferedWriter itemModelWriter;

    public void generate() {
        for (String name : JBlocks.redstoneLampBlockName) {
            String itemModelDir = "../src/main/resources/assets/jitl/models/item/" + name + ".json";
            String blockModelDir = "../src/main/resources/assets/jitl/models/block/" + name + ".json";
            String blockOnModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_on.json";
            String blockstateDir = "../src/main/resources/assets/jitl/blockstates/" + name + ".json";
            File itemModel = new File(itemModelDir);
            File blockModel = new File(blockModelDir);
            File blockOnModel = new File(blockOnModelDir);
            File blockstateModel = new File(blockstateDir);
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
                if (blockModel.exists()) {
                    blockModel.delete();
                }
                blockModel.createNewFile();
                this.blockModelWriter = new BufferedWriter(new FileWriter(blockModel));
                if (blockOnModel.exists()) {
                    blockOnModel.delete();
                }
                blockOnModel.createNewFile();
                this.blockOnModelWriter = new BufferedWriter(new FileWriter(blockOnModel));
                if (blockstateModel.exists()) {
                    blockstateModel.delete();
                }
                blockstateModel.createNewFile();
                this.blockstateWriter = new BufferedWriter(new FileWriter(blockstateModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getBlockItem("jitl", name);
            this.getBlockModel("jitl", name);
            this.getBlockstate("jitl", name);
            this.generateBasicFile(name);
            this.writerInit();
        }
    }

    public void getBlockItem(String modID, String name) {
        this.writeToItemModelFile("{");
        this.writeToItemModelFile("  \"parent\": \"" + modID + ":block/" + name + "\"");
        this.writeToItemModelFile("}");
    }

    public void getBlockModel(String modID, String name) {
        this.writeToBlockModelFile("{");
        this.writeToBlockModelFile("  \"parent\": \"minecraft:block/cube_all\",");
        this.writeToBlockModelFile("  \"textures\": {");
        this.writeToBlockModelFile("    \"all\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockModelFile("  }");
        this.writeToBlockModelFile("}");
        this.writeToOnBlockModelFile("{");
        this.writeToOnBlockModelFile("  \"parent\": \"minecraft:block/cube_all\",");
        this.writeToOnBlockModelFile("  \"textures\": {");
        this.writeToOnBlockModelFile("    \"all\": \"" + modID + ":block/" + name + "_on\"");
        this.writeToOnBlockModelFile("  }");
        this.writeToOnBlockModelFile("}");
    }

    public void getBlockstate(String modID, String name) {
        this.writeToBlockstateFile("{");
        this.writeToBlockstateFile("  \"variants\": {");
        this.writeToBlockstateFile("    \"lit=false\": {");
        this.writeToBlockstateFile("      \"model\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    \"lit=true\": {");
        this.writeToBlockstateFile("      \"model\": \"" + modID + ":block/" + name + "_on\"");
        this.writeToBlockstateFile("    }");
        this.writeToBlockstateFile("  }");
        this.writeToBlockstateFile("}");
    }

    public void writerInit() {
        try {
            this.itemModelWriter.close();
            this.blockModelWriter.close();
            this.blockOnModelWriter.close();
            this.blockstateWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToItemModelFile(String text) {
        try {
            this.itemModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockModelFile(String text) {
        try {
            this.blockModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToOnBlockModelFile(String text) {
        try {
            this.blockOnModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockstateFile(String text) {
        try {
            this.blockstateWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

