/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.helper;

import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public class TooltipFiller {
    private final Consumer<Component> tooltip;
    private final String key;
    private int line = 0;
    private final int startPoint;

    public TooltipFiller(Consumer<Component> text, String itemKey) {
        this.tooltip = text;
        this.key = itemKey;
        this.startPoint = -1;
    }

    public TooltipFiller(Consumer<Component> text, String itemKey, int start) {
        this.tooltip = text;
        this.key = itemKey;
        this.startPoint = start;
    }

    public void addTooltip(ChatFormatting color) {
        if (this.startPoint == -1) {
            this.tooltip.accept((Component)Component.translatable((String)("jitl.tooltip." + this.key + "." + this.line++)).withStyle(color));
        }
    }

    public void addOverview() {
        this.addTooltip(ChatFormatting.GOLD);
    }

    public void addDetail() {
        this.addTooltip(ChatFormatting.AQUA);
    }

    public void addDrawback() {
        this.addTooltip(ChatFormatting.RED);
    }

    public void addValue(Object ... values) {
        this.tooltip.accept((Component)Component.translatable((String)("jitl.tooltip." + this.key + "." + this.line++), (Object[])values).withStyle(ChatFormatting.GREEN));
    }

    public void addBreak() {
        this.tooltip.accept((Component)Component.empty());
    }
}

