/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.jitl.client.render.world.BoilRenderInfo;
import net.jitl.client.render.world.CloudiaRenderInfo;
import net.jitl.client.render.world.CorbaRenderInfo;
import net.jitl.client.render.world.EucaRenderInfo;
import net.jitl.client.render.world.FrozenRenderInfo;
import net.jitl.client.render.world.TerraniaRenderInfo;
import net.jitl.client.util.ClientGetter;
import net.jitl.common.capability.stats.PlayerStats;
import net.jitl.common.world.dimension.Dimensions;
import net.jitl.core.init.internal.JDataAttachments;
import net.jitl.core.init.internal.JItems;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@EventBusSubscriber(modid="jitl", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEventHandler {
    public static void regToBus(IEventBus forgeBus) {
        forgeBus.addListener(ClientEventHandler::onFogDensityEvent);
    }

    public static void onFogDensityEvent(ViewportEvent.RenderFog event) {
        float density;
        float farPlaneDistance = event.getFarPlaneDistance();
        Player player = ClientGetter.player();
        if (ClientGetter.level().dimension() == Dimensions.FROZEN_LANDS) {
            ICuriosItemHandler curios = (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)player).get();
            density = ((PlayerStats)player.getData(JDataAttachments.PLAYER_STATS)).hasBlizzard() || curios.findFirstCurio((Item)JItems.EYE_OF_THE_BLIZZARD.get()).isPresent() ? 0.55f : 0.1f;
            RenderSystem.setShaderFogStart((float)density);
            RenderSystem.setShaderFogEnd((float)(density * farPlaneDistance));
        }
        if (ClientGetter.level().dimension() == Dimensions.CLOUDIA) {
            density = 0.35f;
            RenderSystem.setShaderFogStart((float)density);
            RenderSystem.setShaderFogEnd((float)(density * farPlaneDistance));
        }
        if (ClientGetter.level().dimension() == Dimensions.DEPTHS) {
            density = 1.5f;
            RenderSystem.setShaderFogStart((float)density);
            RenderSystem.setShaderFogEnd((float)(density * farPlaneDistance));
        }
    }

    @SubscribeEvent
    public static void registerDimensionSpecialEffects(RegisterDimensionSpecialEffectsEvent event) {
        event.register(Dimensions.EUCA_EFFECTS, (DimensionSpecialEffects)new EucaRenderInfo());
        event.register(Dimensions.DEPTHS_EFFECTS, (DimensionSpecialEffects)new EucaRenderInfo());
        event.register(Dimensions.BOIL_EFFECTS, (DimensionSpecialEffects)new BoilRenderInfo());
        event.register(Dimensions.FROZEN_EFFECTS, (DimensionSpecialEffects)new FrozenRenderInfo());
        event.register(Dimensions.CORBA_EFFECTS, (DimensionSpecialEffects)new CorbaRenderInfo());
        event.register(Dimensions.TERRANIA_EFFECTS, (DimensionSpecialEffects)new TerraniaRenderInfo());
        event.register(Dimensions.CLOUDIA_EFFECTS, (DimensionSpecialEffects)new CloudiaRenderInfo());
    }
}

