/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client;

import com.google.common.collect.Sets;
import java.util.Set;
import net.jitl.common.entity.base.JBoat;
import net.jitl.core.init.JITL;
import net.minecraft.client.model.geom.ModelLayerLocation;

public class JModelLayers {
    private static final Set<ModelLayerLocation> ALL_MODELS = Sets.newHashSet();
    public static final ModelLayerLocation JCHEST = JModelLayers.register("jchest");
    public static final ModelLayerLocation JDOUBLE_CHEST_LEFT = JModelLayers.register("jdouble_chest_left");
    public static final ModelLayerLocation JDOUBLE_CHEST_RIGHT = JModelLayers.register("jdouble_chest_right");
    public static final ModelLayerLocation FROZEN_TROLL_MODEL_LAYER = JModelLayers.register("frozen_troll");
    public static final ModelLayerLocation SHIVERWOLF_MODEL_LAYER = JModelLayers.register("shiverwolf");
    public static final ModelLayerLocation SHIVERWOLF_ARMOR_LAYER = JModelLayers.register("shiverwolf_armor");

    private static ModelLayerLocation register(String path) {
        return JModelLayers.register(path, "main");
    }

    private static ModelLayerLocation register(String path, String model) {
        ModelLayerLocation modellayerlocation = JModelLayers.createLocation(path, model);
        if (!ALL_MODELS.add(modellayerlocation)) {
            throw new IllegalStateException("Duplicate registration for " + String.valueOf(modellayerlocation));
        }
        return modellayerlocation;
    }

    private static ModelLayerLocation createLocation(String path, String model) {
        return new ModelLayerLocation(JITL.rl(path), model);
    }

    public static ModelLayerLocation createBoatModelName(JBoat.Type type) {
        return JModelLayers.createLocation("boat/" + type.getName(), "main");
    }
}

