/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import net.jitl.common.capability.player.Portal;
import net.jitl.core.init.internal.JDataAttachments;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PortalOverlayRenderer
implements LayeredDraw.Layer {
    public void render(GuiGraphics pGuiGraphics, DeltaTracker deltaTracker) {
        Portal playerPortalOverlay;
        float timeInPortal;
        Minecraft minecraft = Minecraft.getInstance();
        int screenWidth = minecraft.getWindow().getGuiScaledWidth();
        int screenHeight = minecraft.getWindow().getGuiScaledHeight();
        LocalPlayer player = minecraft.player;
        if (player != null && (timeInPortal = (playerPortalOverlay = (Portal)player.getData(JDataAttachments.PORTAL_OVERLAY)).getOldPortalOverlayTime() * 1.45f + (playerPortalOverlay.getPortalOverlayTime() - playerPortalOverlay.getOldPortalOverlayTime()) * deltaTracker.getGameTimeDeltaTicks()) > 0.0f) {
            if (timeInPortal < 1.0f) {
                timeInPortal *= timeInPortal;
                timeInPortal *= timeInPortal;
                timeInPortal = timeInPortal * 0.8f + 0.2f;
            }
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            pGuiGraphics.setColor(1.0f, 1.0f, 1.0f, timeInPortal);
            TextureAtlasSprite textureatlassprite = Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getParticleIcon(playerPortalOverlay.getPortalBlockToRender().defaultBlockState());
            pGuiGraphics.blit(0, 0, -90, pGuiGraphics.guiWidth(), pGuiGraphics.guiHeight(), textureatlassprite);
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            pGuiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

