/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import net.jitl.client.util.EnumHexColor;
import net.jitl.common.scroll.IDescComponent;
import net.jitl.common.scroll.ScrollEntry;
import net.jitl.core.helper.internal.DrawHelper;
import net.jitl.core.init.JITL;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

public class LoreScrollEntryScreen
extends Screen {
    private static final ResourceLocation BG = JITL.rl("textures/gui/scroll_base.png");
    private static final int SLIDER_LIGHT_COLOR = -1720955;
    private static final int SLIDER_PATH_COLOR = 859581460;
    private static final int SLIDER_DARK_COLOR = -4093380;
    private final int headerHeight = 30;
    private final ScrollEntry scrollEntry;
    private int guiWidth;
    private int guiHeight;
    private int guix0;
    private int guiy0;
    private int mouseX;
    private int mouseY;
    private int entryWidth;
    private int top;
    private int bottom;
    private int left;
    private float initialMouseClickY = -2.0f;
    private float scrollDistance;
    private float scrollFactor;

    public LoreScrollEntryScreen(ScrollEntry ScrollEntry2) {
        super((Component)Component.translatable((String)"jitl.lore_scroll"));
        this.scrollEntry = ScrollEntry2;
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    private void drawScreen(int mouseX, int mouseY) {
    }

    private int getContentPartCount() {
        return this.scrollEntry.getDesc().size();
    }

    private int getContentHeight() {
        int conHeight = this.headerHeight;
        for (IDescComponent part : this.scrollEntry.getDesc()) {
            conHeight += part.getContentPartHeight();
        }
        return conHeight;
    }

    private int getContentPartHeight(int index) {
        return this.scrollEntry.getDesc().get(index).getContentPartHeight();
    }

    private void determineAllContentPartHeight(int width) {
        for (IDescComponent part : this.scrollEntry.getDesc()) {
            part.determineContentPartHeight(width);
        }
    }

    private void drawHeader(GuiGraphics poseStack, int maxX, int y0, Tesselator tess) {
        float zLevel = this.getContentHeight();
        if (this.scrollEntry.hasComment()) {
            this.drawCenteredStringWithCustomScale(poseStack, this.font, (FormattedText)Component.translatable((String)this.scrollEntry.getTitleKey()), this.left + (maxX - this.left) / 2 + 1, y0, (int)zLevel, EnumHexColor.BLACK, 1.5f, 25);
            if (this.scrollEntry.getCommentKey() != null) {
                MutableComponent mutableComponent = Component.translatable((String)this.scrollEntry.getCommentKey());
                int n = this.left + (maxX - this.left) / 2 + 1;
                Objects.requireNonNull(this.font);
                this.drawCenteredStringWithCustomScale(poseStack, this.font, (FormattedText)mutableComponent, n, y0 + (int)((double)9.0f * 0.7), (int)zLevel, EnumHexColor.DARK_BROWN, 1.0f, 35);
            }
        } else {
            this.drawCenteredStringWithCustomScale(poseStack, this.font, (FormattedText)Component.translatable((String)this.scrollEntry.getTitleKey()), this.left + (maxX - this.left) / 2 + 1, y0, (int)zLevel, EnumHexColor.BLACK, 1.2f, 30);
        }
    }

    public void drawCenteredStringWithCustomScale(GuiGraphics gui, Font f, FormattedText comp, int x, int y, int z, EnumHexColor colour, float size, int avaliableHeight) {
        float f2;
        gui.pose().pushPose();
        PoseStack poseStack = gui.pose();
        double d = (double)x - (double)f.width(comp) / 2.0 * (double)size;
        double d2 = (double)y + (double)avaliableHeight / 2.0;
        Objects.requireNonNull(f);
        if (9.0f * size > 1.0f) {
            Objects.requireNonNull(f);
            f2 = (float)(-1 * 9) * size;
        } else {
            Objects.requireNonNull(f);
            f2 = 9.0f * size;
        }
        poseStack.translate(d, d2 + (double)f2 * 0.5, (double)z);
        gui.pose().scale(size, size, size);
        gui.drawString(f, comp.getString(), 0, 0, colour.getInt(), false);
        gui.pose().popPose();
    }

    private void drawContentPart(GuiGraphics poseStack, int partIdx, int contentRight, int partTop, int partBuffer, Tesselator tess) {
        this.scrollEntry.getDesc().get(partIdx).drawContentPart(poseStack, this.left + 2, partTop, contentRight);
    }

    private void applyScrollLimits() {
        int listHeight = this.getContentHeight() - (this.bottom - this.top - 4);
        if (listHeight < 0) {
            listHeight /= 2;
        }
        if (this.scrollDistance < 0.0f) {
            this.scrollDistance = 0.0f;
        }
        if (this.scrollDistance > (float)listHeight) {
            this.scrollDistance = listHeight;
        }
    }

    public void render(@NotNull GuiGraphics poseStack, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(poseStack, mouseX, mouseY, partialTicks);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BG);
        int heightRectCount = (this.height - (this.height <= 480 ? 12 : 48)) / 32;
        int widthRectCount = this.height <= 480 ? 6 : 10;
        this.guiWidth = widthRectCount * 32;
        this.guiHeight = heightRectCount * 32;
        this.guix0 = this.width / 2 - this.guiWidth / 2;
        this.guiy0 = this.height / 2 - this.guiHeight / 2;
        for (int x = 0; x < widthRectCount; ++x) {
            for (int y = 0; y < heightRectCount; ++y) {
                int textureX;
                int n = x == 0 ? 0 : (textureX = x == widthRectCount - 1 ? 64 : 32);
                int textureY = y == 0 ? 0 : (y == heightRectCount - 1 ? 64 : 32);
                poseStack.blit(BG, this.guix0 + x * 32, this.guiy0 + y * 32, textureX, textureY, 32, 32);
            }
        }
        this.drawScrollingContent(poseStack, mouseX, mouseY);
    }

    private void drawScrollingContent(GuiGraphics poseStack, int mouseX, int mouseY) {
        int indent = 17;
        this.left = this.guix0 + indent + 4;
        this.top = this.guiy0 + indent;
        this.entryWidth = this.guiWidth - indent * 2;
        int entryHeight = this.guiHeight - indent * 2;
        this.bottom = this.top + entryHeight;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        boolean isHovering = mouseX >= this.left && mouseX <= this.left + this.entryWidth && mouseY >= this.top && mouseY <= this.bottom;
        int entryLength = this.getContentPartCount();
        int scrollButtonWidth = 3;
        int scrollButtonRightTop = this.left + this.entryWidth;
        int scrollButtonLeftTop = scrollButtonRightTop - scrollButtonWidth;
        int contentRightTop = scrollButtonLeftTop - 5;
        this.determineAllContentPartHeight(contentRightTop - this.left - 4);
        int viewHeight = this.bottom - this.top;
        int border = 4;
        assert (this.minecraft != null);
        MouseHandler mouseHandler = new MouseHandler(this.minecraft);
        if (mouseHandler.isLeftPressed()) {
            if (this.initialMouseClickY == -1.0f) {
                if (isHovering) {
                    if (mouseX >= scrollButtonLeftTop && mouseX <= scrollButtonRightTop) {
                        int var13;
                        this.scrollFactor = -1.0f;
                        int scrollHeight = this.getContentHeight() - viewHeight - border;
                        if (scrollHeight < 1) {
                            scrollHeight = 1;
                        }
                        if ((var13 = (int)((float)(viewHeight * viewHeight) / (float)this.getContentHeight())) < 32) {
                            var13 = 32;
                        }
                        if (var13 > viewHeight - border * 2) {
                            var13 = viewHeight - border * 2;
                        }
                        this.scrollFactor /= (float)(viewHeight - var13) / (float)scrollHeight;
                    } else {
                        this.scrollFactor = 1.0f;
                    }
                    this.initialMouseClickY = mouseY;
                } else {
                    this.initialMouseClickY = -2.0f;
                }
            } else if (this.initialMouseClickY >= 0.0f) {
                this.scrollDistance -= ((float)mouseY - this.initialMouseClickY) * this.scrollFactor;
                this.initialMouseClickY = mouseY;
            }
        } else {
            this.initialMouseClickY = -1.0f;
        }
        this.applyScrollLimits();
        Tesselator tess = Tesselator.getInstance();
        double scaleW = (double)this.minecraft.getWindow().getScreenWidth() / (double)this.minecraft.getWindow().getGuiScaledWidth();
        double scaleH = (double)this.minecraft.getWindow().getScreenHeight() / (double)this.minecraft.getWindow().getGuiScaledHeight();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)((double)this.left * scaleW)), (int)((int)((double)this.minecraft.getWindow().getScreenHeight() - (double)this.bottom * scaleH)), (int)((int)((double)this.entryWidth * scaleW)), (int)((int)((double)viewHeight * scaleH)));
        int baseY = this.top + border - (int)this.scrollDistance;
        int indentY = 0;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int partIdx = 0; partIdx < entryLength; ++partIdx) {
            int partTop = baseY + this.headerHeight + indentY;
            int partBuffer = this.getContentPartHeight(partIdx) - border;
            if (baseY + 30 >= this.top) {
                this.drawHeader(poseStack, contentRightTop, baseY, tess);
            }
            if (partTop <= this.bottom && partTop + partBuffer >= this.top) {
                int min = this.left;
                int max = contentRightTop;
                this.drawContentPart(poseStack, partIdx, max - min - 4, partTop, partBuffer, tess);
            }
            indentY += this.scrollEntry.getDesc().get(partIdx).getContentPartHeight();
        }
        int extraHeight = this.getContentHeight() + border - viewHeight;
        if (extraHeight > 0) {
            int barTop;
            int height = viewHeight * viewHeight / this.getContentHeight();
            if (height < 32) {
                height = 32;
            }
            if (height > viewHeight - border * 2) {
                height = viewHeight - border * 2;
            }
            if ((barTop = (int)this.scrollDistance * (viewHeight - height) / extraHeight + this.top) < this.top) {
                barTop = this.top;
            }
            RenderSystem.disableBlend();
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int alpha = DrawHelper.getAlpha(859581460);
            int red = DrawHelper.getRed(859581460);
            int green = DrawHelper.getGreen(859581460);
            int blue = DrawHelper.getBlue(859581460);
            BufferBuilder worldr = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            worldr.addVertex((float)scrollButtonLeftTop, (float)this.bottom, 0.0f).setUv(0.0f, 1.0f).setColor(red, green, blue, alpha);
            worldr.addVertex((float)scrollButtonRightTop, (float)this.bottom, 0.0f).setUv(1.0f, 1.0f).setColor(red, green, blue, alpha);
            worldr.addVertex((float)scrollButtonRightTop, (float)this.top, 0.0f).setUv(1.0f, 0.0f).setColor(red, green, blue, alpha);
            worldr.addVertex((float)scrollButtonLeftTop, (float)this.top, 0.0f).setUv(0.0f, 0.0f).setColor(red, green, blue, alpha);
            BufferUploader.drawWithShader((MeshData)worldr.buildOrThrow());
            alpha = DrawHelper.getAlpha(-4093380);
            red = DrawHelper.getRed(-4093380);
            green = DrawHelper.getGreen(-4093380);
            blue = DrawHelper.getBlue(-4093380);
            worldr = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            worldr.addVertex((float)scrollButtonLeftTop, (float)(barTop + height), 0.0f).setUv(0.0f, 1.0f).setColor(red, green, blue, alpha);
            worldr.addVertex((float)scrollButtonRightTop, (float)(barTop + height), 0.0f).setUv(1.0f, 1.0f).setColor(red, green, blue, alpha);
            worldr.addVertex((float)scrollButtonRightTop, (float)barTop, 0.0f).setUv(1.0f, 0.0f).setColor(red, green, blue, alpha);
            worldr.addVertex((float)scrollButtonLeftTop, (float)barTop, 0.0f).setUv(0.0f, 0.0f).setColor(red, green, blue, alpha);
            BufferUploader.drawWithShader((MeshData)worldr.buildOrThrow());
            alpha = DrawHelper.getAlpha(-1720955);
            red = DrawHelper.getRed(-1720955);
            green = DrawHelper.getGreen(-1720955);
            blue = DrawHelper.getBlue(-1720955);
            worldr = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            worldr.addVertex((float)scrollButtonLeftTop, (float)(barTop + height - 1), 0.0f).setUv(0.0f, 1.0f).setColor(red, green, blue, alpha);
            worldr.addVertex((float)(scrollButtonRightTop - 1), (float)(barTop + height - 1), 0.0f).setUv(1.0f, 1.0f).setColor(red, green, blue, alpha);
            worldr.addVertex((float)(scrollButtonRightTop - 1), (float)barTop, 0.0f).setUv(1.0f, 0.0f).setColor(red, green, blue, alpha);
            worldr.addVertex((float)scrollButtonLeftTop, (float)barTop, 0.0f).setUv(0.0f, 0.0f).setColor(red, green, blue, alpha);
            BufferUploader.drawWithShader((MeshData)worldr.buildOrThrow());
            RenderSystem.disableBlend();
        }
        this.drawScreen(mouseX, mouseY);
        RenderSystem.enableBlend();
        RenderSystem.disableBlend();
        GL11.glDisable((int)3089);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        boolean isHovering;
        boolean bl = isHovering = this.mouseX >= this.left && this.mouseX <= this.left + this.entryWidth && this.mouseY >= this.top && this.mouseY <= this.bottom;
        if (!isHovering) {
            return false;
        }
        this.scrollDistance += (float)(-1.0 * pScrollY * 2.0);
        return super.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers_) {
        if (keyCode == 256) {
            assert (this.minecraft != null);
            this.minecraft.setScreen(null);
        }
        return true;
    }
}

