/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.gui.screen;

import net.jitl.client.stats.ClientPlayerStats;
import net.jitl.common.entity.jmerchant.SentacoinMerchantMenu;
import net.jitl.core.data.JNetworkRegistry;
import net.jitl.core.init.JITL;
import net.jitl.core.init.internal.JBlocks;
import net.jitl.core.init.network.PacketBuyItem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class SentacoinMerchantScreen
extends AbstractContainerScreen<SentacoinMerchantMenu> {
    private static final ResourceLocation MERCHANT_LOCATION = JITL.rl("textures/gui/merchant.png");
    private static final Component TRADES_LABEL = Component.translatable((String)"merchant.trades");

    public SentacoinMerchantScreen(SentacoinMerchantMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.imageWidth = 220;
        this.imageHeight = 220;
    }

    protected void init() {
        super.init();
        this.addButton(0, 86, new ItemStack((ItemLike)JBlocks.BREAKABLE_SENTERIAN_BARS.get()), 16, 64);
        this.addButton(0, 107, new ItemStack((ItemLike)JBlocks.BREAKABLE_SENTERIAN_BRICKS.get()), 16, 64);
        this.addButton(0, 128, new ItemStack((ItemLike)JBlocks.BREAKABLE_SENTERIAN_BRICK_STAIRS.get()), 16, 64);
        this.addButton(0, 149, new ItemStack((ItemLike)JBlocks.BREAKABLE_SENTERIAN_CARVED_ROCK.get()), 16, 64);
        this.addButton(0, 170, new ItemStack((ItemLike)JBlocks.BREAKABLE_SENTERIAN_FLOOR.get()), 16, 64);
        this.addButton(0, 191, new ItemStack((ItemLike)JBlocks.BREAKABLE_SENTERIAN_ROCK.get()), 16, 64);
        this.addButton(0, 212, new ItemStack((ItemLike)JBlocks.BREAKABLE_SENTERIAN_GLASS.get()), 16, 64);
        this.addButton(0, 233, new ItemStack((ItemLike)JBlocks.BREAKABLE_SENTERIAN_POST.get()), 16, 64);
        this.addButton(0, 254, new ItemStack((ItemLike)JBlocks.BREAKABLE_SENTERIAN_GUARDIAN_LAMP.get()), 16, 64);
        this.addButton(104, 86, new ItemStack((ItemLike)JBlocks.BREAKABLE_SENTERIAN_LIGHT_LAMP.get()), 16, 64);
        this.addButton(104, 107, new ItemStack((ItemLike)JBlocks.BREAKABLE_SENTERIAN_MELLOW_LAMP.get()), 16, 64);
    }

    protected void renderLabels(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        MutableComponent component = Component.literal((String)("Sentacoins: " + ClientPlayerStats.getSentacoins()));
        int j = this.font.width((FormattedText)component);
        int k = 49 + this.imageWidth / 2 - j / 2;
        pGuiGraphics.drawString(this.font, (Component)component, k, 6, 0x404040, false);
        int l = this.font.width((FormattedText)TRADES_LABEL);
        pGuiGraphics.drawString(this.font, TRADES_LABEL, 5 - l / 2 + 53, 6, 0x404040, false);
    }

    protected void renderBg(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        pGuiGraphics.blit(MERCHANT_LOCATION, i, j, 0, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    public void render(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    public void addButton(int x, int y, ItemStack item, int amount, int cost) {
        Button b = (Button)this.addRenderableWidget((GuiEventListener)new TradeOfferButton(this, item.getItem().getDescriptionId(), this.width / 2 - 100 + x, this.height / 2 - 175 + y, item, amount, cost));
        b.visible = true;
        b.active = true;
    }

    public void buy(ItemStack item, int amount, int cost) {
        JNetworkRegistry.sendToServer(new PacketBuyItem(String.valueOf(item.getItem()), amount, cost));
    }

    class TradeOfferButton
    extends Button {
        public TradeOfferButton(SentacoinMerchantScreen this$0, String name, int pX, int pY, ItemStack i, int amount, int cost) {
            super(pX, pY, 96, 20, (Component)Component.translatable((String)name), press -> this$0.buy(i, amount, cost), DEFAULT_NARRATION);
            this.setTooltip(Tooltip.create((Component)Component.literal((String)(" x" + amount + " for x" + cost + " Sentacoins"))));
        }
    }
}

