/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.gui.screen.dialogue;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.jitl.client.gui.screen.dialogue.GuiOptionButton;
import net.jitl.client.util.Rectangle;
import net.jitl.common.dialogue.ClientDialogueNode;
import net.jitl.common.network.dialogue.C2SChosenOptionMsg;
import net.jitl.core.data.JNetworkRegistry;
import net.jitl.core.helper.internal.ArgbColor;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class GuiDialogue
extends Screen {
    private static final int INDENT = 6;
    private static final int INDENT_OFFSET = 8;
    protected int centerX;
    protected int centerY;
    private final ClientDialogueNode node;
    private Rectangle guiRect;
    private Rectangle mobIconRect;
    private Rectangle optionsRect;
    private Rectangle mobTextRect;

    public GuiDialogue(ClientDialogueNode node) {
        super((Component)Component.translatable((String)"jitl.dialogue"));
        this.node = node;
    }

    public void init() {
        this.centerX = this.width / 2;
        this.centerY = this.height / 2;
        int guiWidth = 300;
        int guiHeight = 200;
        int mobIconWidth = 80;
        int mobIconHeight = 80;
        this.guiRect = Rectangle.fromWidthAndHeight(this.centerX - guiWidth / 2, this.centerY - guiHeight / 2, guiWidth, guiHeight);
        int mobIconRight = this.guiRect.right() - 6;
        int mobIconTop = this.guiRect.top() + 6;
        this.mobIconRect = new Rectangle(mobIconRight - mobIconWidth, this.guiRect.top() + 6, mobIconRight, mobIconTop + mobIconHeight);
        int horizontalSinglePart = 6 * guiWidth;
        this.optionsRect = new Rectangle(this.guiRect.left() + horizontalSinglePart, this.mobIconRect.bottom() + 6, this.guiRect.right() - horizontalSinglePart, this.guiRect.bottom() - 6);
        this.mobTextRect = new Rectangle(this.guiRect.left() + 6, this.mobIconRect.top(), this.mobIconRect.left() - 6, this.mobIconRect.bottom());
        this.initOptionButtons();
    }

    private void initOptionButtons() {
        int indent;
        int allHeight = this.guiRect.height() - 6 - this.optionsRect.top();
        int buttonHeight = 20;
        List<String> options = this.node.getOptionTextKeys();
        int optionsCenterY = this.optionsRect.top() + allHeight / 2;
        int indentCount = options.size() - 1;
        int minimalIndent = 1;
        if (indentCount != 0) {
            int allIndent = (allHeight - buttonHeight * options.size()) / indentCount;
            indent = allIndent / indentCount;
        } else {
            indent = 0;
        }
        indent = Math.min(Math.max(indent, minimalIndent), 6);
        int startY = optionsCenterY - buttonHeight * options.size() / 2 - indent * (indentCount / 2);
        int incrementor = buttonHeight + indent;
        int x = this.mobTextRect.left() + -48;
        for (int i = 0; i < options.size(); ++i) {
            int finalI = i;
            this.addRenderableWidget((GuiEventListener)new GuiOptionButton(options.get(i), button -> {
                System.out.println("Hi");
                JNetworkRegistry.sendToServer(new C2SChosenOptionMsg(finalI));
            }, x, startY));
            startY += incrementor;
        }
    }

    public void render(@NotNull GuiGraphics poseStack, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(poseStack, mouseX, mouseY, partialTicks);
        this.drawDebugLayout(mouseX, mouseY, partialTicks);
        this.drawMobText(poseStack);
        GuiDialogue.drawEntity(this.width / 8 * 6, (int)((float)this.mobIconRect.bottom() - (float)this.mobIconRect.height() * -3.75f), mouseX, mouseY, this.node.getNpc(), poseStack);
        System.out.println(this.node.getOptionTextKeys());
    }

    private void drawMobText(GuiGraphics stack) {
        String text = String.valueOf(ChatFormatting.YELLOW) + String.valueOf(ChatFormatting.ITALIC) + this.node.getTextKey();
        stack.drawString(this.font, text, this.mobTextRect.left() + -48, this.mobTextRect.top() + 6 + 64, ArgbColor.from(ChatFormatting.WHITE));
    }

    private void drawDebugLayout(int mouseX, int mouseY, float partialTicks) {
    }

    public static void drawEntity(int posX, int posY, float mouseX, float mouseY, LivingEntity entity, GuiGraphics g) {
        float scaleFactor = entity.getEyeHeight() / 1.8f;
        scaleFactor = Math.max(scaleFactor, 0.5f);
        int adaptiveScale = (int)(164.0f / scaleFactor);
        int playerEyeHeight = (int)entity.getEyeHeight() * (int)((float)adaptiveScale * 2.0f);
        float eyeOffset = (float)playerEyeHeight * entity.getEyeHeight() / (1.65f * scaleFactor);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)g, (int)posX, (int)posY, (int)((int)((float)posX - mouseX)), (int)((int)((float)posY - mouseY - eyeOffset)), (int)adaptiveScale, (float)0.0625f, (float)mouseX, (float)mouseY, (LivingEntity)entity);
    }
}

