/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.model;

import com.google.common.collect.ImmutableList;
import net.jitl.common.entity.frozen.Shiverwolf;
import net.minecraft.client.model.ColorableAgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ShiverwolfModel<T extends Shiverwolf>
extends ColorableAgeableListModel<T> {
    private final ModelPart head;
    private final ModelPart realHead;
    private final ModelPart body;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart tail;
    private final ModelPart realTail;
    private final ModelPart upperBody;

    public ShiverwolfModel(ModelPart root) {
        this.head = root.getChild("head");
        this.realHead = this.head.getChild("real_head");
        this.body = root.getChild("body");
        this.upperBody = root.getChild("upper_body");
        this.rightHindLeg = root.getChild("right_hind_leg");
        this.leftHindLeg = root.getChild("left_hind_leg");
        this.rightFrontLeg = root.getChild("right_front_leg");
        this.leftFrontLeg = root.getChild("left_front_leg");
        this.tail = root.getChild("tail");
        this.realTail = this.tail.getChild("real_tail");
    }

    public static MeshDefinition createMeshDefinition(CubeDeformation cubeDeformation) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        float f = 13.5f;
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)13.5f, (float)-7.0f));
        partdefinition1.addOrReplaceChild("real_head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -3.0f, -2.0f, 6.0f, 6.0f, 4.0f, cubeDeformation).texOffs(16, 14).addBox(-2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, cubeDeformation).texOffs(16, 14).addBox(2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, cubeDeformation).texOffs(0, 10).addBox(-0.5f, -0.001f, -5.0f, 3.0f, 3.0f, 4.0f, cubeDeformation), PartPose.ZERO);
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(18, 14).addBox(-3.0f, -2.0f, -3.0f, 6.0f, 9.0f, 6.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)2.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("upper_body", CubeListBuilder.create().texOffs(21, 0).addBox(-3.0f, -3.0f, -3.0f, 8.0f, 6.0f, 7.0f, cubeDeformation), PartPose.offsetAndRotation((float)-1.0f, (float)14.0f, (float)-3.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        CubeListBuilder cubelistbuilder = CubeListBuilder.create().texOffs(0, 18).addBox(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, cubeDeformation);
        partdefinition.addOrReplaceChild("right_hind_leg", cubelistbuilder, PartPose.offset((float)-2.5f, (float)16.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("left_hind_leg", cubelistbuilder, PartPose.offset((float)0.5f, (float)16.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("right_front_leg", cubelistbuilder, PartPose.offset((float)-2.5f, (float)16.0f, (float)-4.0f));
        partdefinition.addOrReplaceChild("left_front_leg", cubelistbuilder, PartPose.offset((float)0.5f, (float)16.0f, (float)-4.0f));
        PartDefinition partdefinition2 = partdefinition.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-1.0f, (float)12.0f, (float)8.0f, (float)0.62831855f, (float)0.0f, (float)0.0f));
        partdefinition2.addOrReplaceChild("real_tail", CubeListBuilder.create().texOffs(9, 18).addBox(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, cubeDeformation), PartPose.ZERO);
        return meshdefinition;
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg, (Object)this.tail, (Object)this.upperBody);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        this.tail.yRot = entity.isAngry() ? 0.0f : Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        if (entity.isInSittingPose()) {
            this.upperBody.setPos(-1.0f, 16.0f, -3.0f);
            this.upperBody.xRot = 1.2566371f;
            this.upperBody.yRot = 0.0f;
            this.body.setPos(0.0f, 18.0f, 0.0f);
            this.body.xRot = 0.7853982f;
            this.tail.setPos(-1.0f, 21.0f, 6.0f);
            this.rightHindLeg.setPos(-2.5f, 22.7f, 2.0f);
            this.rightHindLeg.xRot = 4.712389f;
            this.leftHindLeg.setPos(0.5f, 22.7f, 2.0f);
            this.leftHindLeg.xRot = 4.712389f;
            this.rightFrontLeg.xRot = 5.811947f;
            this.rightFrontLeg.setPos(-2.49f, 17.0f, -4.0f);
            this.leftFrontLeg.xRot = 5.811947f;
            this.leftFrontLeg.setPos(0.51f, 17.0f, -4.0f);
        } else {
            this.body.setPos(0.0f, 14.0f, 2.0f);
            this.body.xRot = 1.5707964f;
            this.upperBody.setPos(-1.0f, 14.0f, -3.0f);
            this.upperBody.xRot = this.body.xRot;
            this.tail.setPos(-1.0f, 12.0f, 8.0f);
            this.rightHindLeg.setPos(-2.5f, 16.0f, 7.0f);
            this.leftHindLeg.setPos(0.5f, 16.0f, 7.0f);
            this.rightFrontLeg.setPos(-2.5f, 16.0f, -4.0f);
            this.leftFrontLeg.setPos(0.5f, 16.0f, -4.0f);
            this.rightHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.leftHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.rightFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.leftFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        }
        this.realHead.zRot = ((Shiverwolf)((Object)entity)).getHeadRollAngle(partialTick) + ((Shiverwolf)((Object)entity)).getBodyRollAngle(partialTick, 0.0f);
        this.upperBody.zRot = ((Shiverwolf)((Object)entity)).getBodyRollAngle(partialTick, -0.08f);
        this.body.zRot = ((Shiverwolf)((Object)entity)).getBodyRollAngle(partialTick, -0.16f);
        this.realTail.zRot = ((Shiverwolf)((Object)entity)).getBodyRollAngle(partialTick, -0.2f);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.tail.xRot = ageInTicks;
    }
}

