/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.jitl.common.block.BitterwoodCampfireBlock;
import net.jitl.common.block.entity.BitterwoodCampfireBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BitterwoodCampfireRenderer
implements BlockEntityRenderer<BitterwoodCampfireBlockEntity> {
    private final ItemRenderer itemRenderer;

    public BitterwoodCampfireRenderer(BlockEntityRendererProvider.Context pContext) {
        this.itemRenderer = pContext.getItemRenderer();
    }

    public void render(BitterwoodCampfireBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        Direction direction = (Direction)pBlockEntity.getBlockState().getValue((Property)BitterwoodCampfireBlock.FACING);
        NonNullList<ItemStack> nonnulllist = pBlockEntity.getItems();
        int i = (int)pBlockEntity.getBlockPos().asLong();
        for (int j = 0; j < nonnulllist.size(); ++j) {
            ItemStack itemstack = (ItemStack)nonnulllist.get(j);
            if (itemstack == ItemStack.EMPTY) continue;
            pPoseStack.pushPose();
            pPoseStack.translate(0.5f, 0.44921875f, 0.5f);
            Direction direction1 = Direction.from2DDataValue((int)((j + direction.get2DDataValue()) % 4));
            float f = -direction1.toYRot();
            pPoseStack.mulPose(Axis.YP.rotationDegrees(f));
            pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            pPoseStack.translate(-0.3125f, -0.3125f, 0.0f);
            pPoseStack.scale(0.375f, 0.375f, 0.375f);
            this.itemRenderer.renderStatic(itemstack, ItemDisplayContext.FIXED, pPackedLight, pPackedOverlay, pPoseStack, pBuffer, pBlockEntity.getLevel(), i + j);
            pPoseStack.popPose();
        }
    }
}

