/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.jitl.client.JModelLayers;
import net.jitl.common.block.JChestBlock;
import net.jitl.common.block.entity.JChestBlockEntity;
import net.jitl.core.init.JITL;
import net.jitl.core.init.internal.JBlocks;
import net.jitl.core.init.internal.JItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class JChestRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    protected final ModelPart lid;
    protected final ModelPart bottom;
    protected final ModelPart lock;
    protected final ModelPart doubleLeftLid;
    protected final ModelPart doubleLeftBottom;
    protected final ModelPart doubleLeftLock;
    protected final ModelPart doubleRightLid;
    protected final ModelPart doubleRightBottom;
    protected final ModelPart doubleRightLock;

    public JChestRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelpart = context.bakeLayer(JModelLayers.JCHEST);
        this.bottom = modelpart.getChild("bottom");
        this.lid = modelpart.getChild("lid");
        this.lock = modelpart.getChild("lock");
        ModelPart modelpart1 = context.bakeLayer(JModelLayers.JDOUBLE_CHEST_LEFT);
        this.doubleLeftBottom = modelpart1.getChild("bottom");
        this.doubleLeftLid = modelpart1.getChild("lid");
        this.doubleLeftLock = modelpart1.getChild("lock");
        ModelPart modelpart2 = context.bakeLayer(JModelLayers.JDOUBLE_CHEST_RIGHT);
        this.doubleRightBottom = modelpart2.getChild("bottom");
        this.doubleRightLid = modelpart2.getChild("lid");
        this.doubleRightLock = modelpart2.getChild("lock");
    }

    public static LayerDefinition createSingleBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("bottom", CubeListBuilder.create().texOffs(0, 19).addBox(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("lid", CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("lock", CubeListBuilder.create().texOffs(0, 0).addBox(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createDoubleBodyRightLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("bottom", CubeListBuilder.create().texOffs(0, 19).addBox(1.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("lid", CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("lock", CubeListBuilder.create().texOffs(0, 0).addBox(15.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createDoubleBodyLeftLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("bottom", CubeListBuilder.create().texOffs(0, 19).addBox(0.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("lid", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("lock", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void render(T blockEntity, float partialTick, PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Level level = blockEntity.getLevel();
        boolean viable = level != null;
        BlockState blockstate = viable ? blockEntity.getBlockState() : (BlockState)blockEntity.getBlockState().getBlock().defaultBlockState().setValue((Property)JChestBlock.FACING, (Comparable)Direction.SOUTH);
        ChestType chesttype = blockstate.hasProperty(JChestBlock.TYPE) ? (ChestType)blockstate.getValue(JChestBlock.TYPE) : ChestType.SINGLE;
        Block block = blockstate.getBlock();
        JChestBlock chest = (JChestBlock)block;
        boolean isDouble = chesttype != ChestType.SINGLE;
        poseStack.pushPose();
        float f = ((Direction)blockstate.getValue((Property)JChestBlock.FACING)).toYRot();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(-f));
        poseStack.translate(-0.5, -0.5, -0.5);
        DoubleBlockCombiner.NeighborCombineResult<? extends JChestBlockEntity> res = viable ? chest.combine(blockstate, level, blockEntity.getBlockPos(), true) : DoubleBlockCombiner.Combiner::acceptNone;
        float f1 = ((Float2FloatFunction)res.apply(JChestBlock.opennessCombiner((LidBlockEntity)blockEntity))).get(partialTick);
        f1 = 1.0f - f1;
        f1 = 1.0f - f1 * f1 * f1;
        int i = ((Int2IntFunction)res.apply((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(packedLight);
        VertexConsumer vertexconsumer = bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)JITL.rl("textures/models/block/chest/" + this.getNameFromBlock(chest) + ".png")));
        if (isDouble) {
            if (chesttype == ChestType.LEFT) {
                vertexconsumer = bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)JITL.rl("textures/models/block/chest/" + this.getNameFromBlock(chest) + "_left.png")));
                this.render(poseStack, vertexconsumer, this.doubleLeftLid, this.doubleLeftLock, this.doubleLeftBottom, f1, i, packedOverlay);
            } else {
                vertexconsumer = bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)JITL.rl("textures/models/block/chest/" + this.getNameFromBlock(chest) + "_right.png")));
                this.render(poseStack, vertexconsumer, this.doubleRightLid, this.doubleRightLock, this.doubleRightBottom, f1, i, packedOverlay);
            }
        } else {
            this.render(poseStack, vertexconsumer, this.lid, this.lock, this.bottom, f1, i, packedOverlay);
        }
        poseStack.popPose();
        if (((Boolean)blockstate.getValue((Property)JChestBlock.IS_LOCKED)).booleanValue()) {
            if (isDouble) {
                if (chesttype == ChestType.LEFT) {
                    this.renderItem(new ItemStack((ItemLike)JItems.PADLOCK.get()), new double[]{0.0, 0.2, 0.945}, poseStack, bufferSource, packedOverlay, packedLight, blockstate);
                } else {
                    this.renderItem(new ItemStack((ItemLike)JItems.PADLOCK.get()), new double[]{1.0, 0.2, 0.945}, poseStack, bufferSource, packedOverlay, packedLight, blockstate);
                }
            } else {
                this.renderItem(new ItemStack((ItemLike)JItems.PADLOCK.get()), new double[]{0.5, 0.2, 0.945}, poseStack, bufferSource, packedOverlay, packedLight, blockstate);
            }
        }
    }

    private void renderItem(ItemStack stack, double[] translation, PoseStack matrixStack, MultiBufferSource buffer, int combinedOverlay, int lightLevel, BlockState state) {
        ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
        matrixStack.pushPose();
        float f = ((Direction)state.getValue((Property)JChestBlock.FACING)).toYRot();
        matrixStack.translate(0.5, 0.5, 0.5);
        matrixStack.mulPose(Axis.YP.rotationDegrees(-f));
        matrixStack.translate(-0.5, -0.5, -0.5);
        matrixStack.translate(translation[0], translation[1], translation[2]);
        float scale = 1.0f;
        matrixStack.scale(scale, scale, scale + 0.15f);
        BakedModel model = renderer.getModel(stack, null, null, 0);
        renderer.render(stack, ItemDisplayContext.GROUND, true, matrixStack, buffer, lightLevel, combinedOverlay, model);
        matrixStack.popPose();
    }

    public String getNameFromBlock(JChestBlock chest) {
        String name = "";
        if (chest == JBlocks.JOURNEY_CHEST.get()) {
            name = "journey_chest";
        }
        if (chest == JBlocks.EUCA_CHEST.get()) {
            name = "euca_chest";
        }
        if (chest == JBlocks.FROZEN_CHEST.get()) {
            name = "frozen_chest";
        }
        if (chest == JBlocks.BOIL_CHEST.get()) {
            name = "boiling_chest";
        }
        if (chest == JBlocks.NETHER_CHEST.get()) {
            name = "nether_chest";
        }
        if (chest == JBlocks.DEPTHS_CHEST.get()) {
            name = "depths_chest";
        }
        if (chest == JBlocks.CORBA_CHEST.get()) {
            name = "corba_chest";
        }
        if (chest == JBlocks.TERRANIAN_CHEST.get()) {
            name = "terranian_chest";
        }
        if (chest == JBlocks.CLOUDIA_CHEST.get()) {
            name = "cloudia_chest";
        }
        if (chest == JBlocks.SENTERIAN_CHEST.get()) {
            name = "senterian_chest";
        }
        return name;
    }

    private void render(PoseStack poseStack, VertexConsumer consumer, ModelPart lidPart, ModelPart lockPart, ModelPart bottomPart, float lidAngle, int packedLight, int packedOverlay) {
        lockPart.xRot = lidPart.xRot = -(lidAngle * 1.5707964f);
        lidPart.render(poseStack, consumer, packedLight, packedOverlay);
        lockPart.render(poseStack, consumer, packedLight, packedOverlay);
        bottomPart.render(poseStack, consumer, packedLight, packedOverlay);
    }
}

