/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.jitl.common.block.entity.base.JSpawnerEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;

public class JSpawnerRenderer
implements BlockEntityRenderer<JSpawnerEntity> {
    private final EntityRenderDispatcher entityRenderer;

    public JSpawnerRenderer(BlockEntityRendererProvider.Context pContext) {
        this.entityRenderer = pContext.getEntityRenderer();
    }

    public void render(JSpawnerEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        BaseSpawner basespawner;
        Entity entity;
        Level level = pBlockEntity.getLevel();
        if (level != null && (entity = (basespawner = pBlockEntity.getSpawner()).getOrCreateDisplayEntity(level, pBlockEntity.getBlockPos())) != null) {
            JSpawnerRenderer.renderEntityInSpawner(pPartialTick, pPoseStack, pBufferSource, pPackedLight, entity, this.entityRenderer, basespawner.getoSpin(), basespawner.getSpin());
        }
    }

    public static void renderEntityInSpawner(float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, Entity pEntity, EntityRenderDispatcher pEntityRenderer, double pOSpin, double pSpin) {
        pPoseStack.pushPose();
        pPoseStack.translate(0.5f, 0.0f, 0.5f);
        float f = 0.53125f;
        float f1 = Math.max(pEntity.getBbWidth(), pEntity.getBbHeight());
        if ((double)f1 > 1.0) {
            f /= f1;
        }
        pPoseStack.translate(0.0f, 0.4f, 0.0f);
        pPoseStack.mulPose(Axis.YP.rotationDegrees((float)Mth.lerp((double)pPartialTick, (double)pOSpin, (double)pSpin) * 10.0f));
        pPoseStack.translate(0.0f, -0.2f, 0.0f);
        pPoseStack.mulPose(Axis.XP.rotationDegrees(-30.0f));
        pPoseStack.scale(f, f, f);
        pEntityRenderer.render(pEntity, 0.0, 0.0, 0.0, 0.0f, pPartialTick, pPoseStack, pBuffer, pPackedLight);
        pPoseStack.popPose();
    }
}

