/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.render.entity.misc;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.jitl.common.entity.misc.Sentacoin;
import net.jitl.core.init.internal.JItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class SentacoinRender
extends EntityRenderer<Sentacoin> {
    private final ItemRenderer itemRenderer;
    private final Sentacoin.Type type;

    public SentacoinRender(EntityRendererProvider.Context context, Sentacoin.Type type) {
        super(context);
        this.type = type;
        this.shadowRadius = 0.07f;
        this.shadowStrength = 0.75f;
        this.itemRenderer = Minecraft.getInstance().getItemRenderer();
    }

    public void render(@NotNull Sentacoin entity, float entityYaw, float partialTicks, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource buffer, int packedLight) {
        super.render((Entity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
        float angle = (float)(360.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0) / 16.0f;
        float scale = 0.55f;
        ItemStack stack = new ItemStack((ItemLike)JItems.SENTACOIN.get());
        switch (this.type) {
            case COIN: {
                stack = new ItemStack((ItemLike)JItems.SENTACOIN.get());
                break;
            }
            case BAG: {
                stack = new ItemStack((ItemLike)JItems.SENTACOIN_BAG.get());
                scale = 1.0f;
            }
        }
        matrixStack.pushPose();
        matrixStack.scale(scale, scale, scale);
        matrixStack.mulPose(Axis.YP.rotation(angle));
        this.itemRenderer.renderStatic(stack, ItemDisplayContext.GROUND, packedLight, OverlayTexture.NO_OVERLAY, matrixStack, buffer, entity.level(), entity.getId());
        matrixStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    @NotNull
    public ResourceLocation getTextureLocation(Sentacoin e) {
        return InventoryMenu.BLOCK_ATLAS;
    }
}

