/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.render.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.jitl.common.items.base.JShieldItem;
import net.minecraft.client.model.ShieldModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class JShieldRenderer
extends BlockEntityWithoutLevelRenderer {
    private final ShieldModel model;

    public JShieldRenderer(BlockEntityRenderDispatcher renderDispatcher, EntityModelSet modelSet) {
        super(renderDispatcher, modelSet);
        this.model = new ShieldModel(modelSet.bakeLayer(ModelLayers.SHIELD));
    }

    public void renderByItem(@NotNull ItemStack stack, @NotNull ItemDisplayContext context, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        super.renderByItem(stack, context, matrixStack, buffer, combinedLight, combinedOverlay);
        Item item = stack.getItem();
        if (item instanceof JShieldItem) {
            matrixStack.pushPose();
            matrixStack.scale(1.0f, -1.0f, -1.0f);
            VertexConsumer builder = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)((JShieldItem)item).texture));
            this.model.renderToBuffer(matrixStack, builder, combinedLight, combinedOverlay);
            matrixStack.popPose();
        }
    }
}

