/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.render.projectile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Random;
import net.jitl.common.entity.projectile.KnifeEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class KnifeRenderer
extends EntityRenderer<KnifeEntity> {
    private final ItemRenderer itemRenderer;
    private final Random random = new Random();

    public KnifeRenderer(EntityRendererProvider.Context context, ItemRenderer itemRendererIn) {
        super(context);
        this.itemRenderer = itemRendererIn;
        this.shadowRadius = 0.15f;
        this.shadowStrength = 0.75f;
    }

    public void render(KnifeEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.pushPose();
        ItemStack itemstack = entityIn.getItem();
        int i = itemstack.isEmpty() ? 187 : Item.getId((Item)itemstack.getItem()) + itemstack.getDamageValue();
        this.random.setSeed(i);
        BakedModel ibakedmodel = this.itemRenderer.getModel(itemstack, entityIn.level(), null, entityIn.getId());
        float f1 = ((float)entityIn.tickCount + partialTicks) / 10.0f * ((float)Math.PI * 2);
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.yRotO, (float)entityIn.getYRot()) - 90.0f));
        matrixStackIn.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.xRotO, (float)entityIn.getXRot()) + 90.0f));
        if (!entityIn.isInGround()) {
            matrixStackIn.mulPose(Axis.ZP.rotation(f1));
        }
        matrixStackIn.mulPose(Axis.ZP.rotationDegrees(120.0f));
        matrixStackIn.translate(0.0, -0.075, 0.0);
        matrixStackIn.pushPose();
        this.itemRenderer.render(itemstack, ItemDisplayContext.GROUND, false, matrixStackIn, bufferIn, packedLightIn, OverlayTexture.NO_OVERLAY, ibakedmodel);
        matrixStackIn.popPose();
        matrixStackIn.translate(0.0, 0.0, 0.09375);
        matrixStackIn.popPose();
        super.render((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(KnifeEntity entityIn) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

