/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.render.projectile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class RenderProjectile<T extends Entity>
extends EntityRenderer<T> {
    private final RenderType renderType;
    private float scale = 1.0f;
    private final boolean fullBright = true;

    public RenderProjectile(EntityRendererProvider.Context context, ResourceLocation texture) {
        super(context);
        this.renderType = RenderType.entityCutoutNoCull((ResourceLocation)texture);
    }

    public void render(@NotNull T entityIn, float entityYaw, float partialTicks, @NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int packedLightIn) {
        if (((Entity)entityIn).tickCount >= 2 || !(this.entityRenderDispatcher.camera.getEntity().distanceToSqr(entityIn) < 12.25)) {
            this.renderProjectile(matrixStackIn, bufferIn, packedLightIn);
        }
        super.render(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected int getBlockLightLevel(@NotNull T entity, @NotNull BlockPos pos) {
        Objects.requireNonNull(this);
        return 15;
    }

    private void renderProjectile(@NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.pushPose();
        float scale = 0.5f;
        matrixStackIn.scale(scale, scale, scale);
        matrixStackIn.mulPose(this.entityRenderDispatcher.cameraOrientation());
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f));
        matrixStackIn.translate(0.0, 0.5, 0.0);
        matrixStackIn.scale(this.scale, this.scale, this.scale);
        PoseStack.Pose lastMatrix = matrixStackIn.last();
        Matrix4f pose = lastMatrix.pose();
        Matrix3f normal = lastMatrix.normal();
        VertexConsumer ivertexbuilder = bufferIn.getBuffer(this.renderType);
        RenderProjectile.vertex(ivertexbuilder, pose, normal, packedLightIn, 0.0f, 0.0f, 0, 1);
        RenderProjectile.vertex(ivertexbuilder, pose, normal, packedLightIn, 1.0f, 0.0f, 1, 1);
        RenderProjectile.vertex(ivertexbuilder, pose, normal, packedLightIn, 1.0f, 1.0f, 1, 0);
        RenderProjectile.vertex(ivertexbuilder, pose, normal, packedLightIn, 0.0f, 1.0f, 0, 0);
        matrixStackIn.popPose();
    }

    private static void vertex(VertexConsumer builder, Matrix4f pose, Matrix3f normal, int lightmapUV, float x, float y, int u, int v) {
        builder.addVertex(pose, x - 0.5f, y - 0.5f, 0.0f).setColor(255, 255, 255, 255).setUv((float)u, (float)v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(lightmapUV).setNormal(0.0f, 1.0f, 0.0f);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull Entity entityIn) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

