/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.render.vehicle;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.stream.Stream;
import net.jitl.client.JModelLayers;
import net.jitl.client.model.JBoatModel;
import net.jitl.common.entity.base.JBoat;
import net.jitl.core.init.JITL;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class JBoatRenderer
extends EntityRenderer<JBoat> {
    private final Map<JBoat.Type, Pair<ResourceLocation, JBoatModel>> boatResources;

    public JBoatRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.8f;
        this.boatResources = (Map)Stream.of(JBoat.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, JBoatType -> Pair.of((Object)JITL.rl("textures/entity/boat/" + JBoatType.getName() + ".png"), (Object)((Object)new JBoatModel(context.bakeLayer(JModelLayers.createBoatModelName(JBoatType)))))));
    }

    public void render(JBoat entity, float entityYaw, float partialTicks_, PoseStack matrixStack, @NotNull MultiBufferSource buffer, int packedLight) {
        float f2;
        matrixStack.pushPose();
        matrixStack.translate(0.0, 0.375, 0.0);
        matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f - entityYaw));
        float f = (float)entity.getHurtTime() - partialTicks_;
        float f1 = entity.getDamage() - partialTicks_;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            matrixStack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)f) * f * f1 / 10.0f * (float)entity.getHurtDir()));
        }
        if (!Mth.equal((float)(f2 = entity.getBubbleAngle(partialTicks_)), (float)0.0f)) {
            matrixStack.mulPose(new Quaternionf().setAngleAxis(entity.getBubbleAngle(partialTicks_) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<ResourceLocation, JBoatModel> pair = this.getModelWithLocation(entity);
        ResourceLocation resourcelocation = (ResourceLocation)pair.getFirst();
        JBoatModel JBoatmodel = (JBoatModel)((Object)pair.getSecond());
        matrixStack.scale(-1.0f, -1.0f, 1.0f);
        matrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        JBoatmodel.setupAnim(entity, partialTicks_, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = buffer.getBuffer(JBoatmodel.renderType(resourcelocation));
        JBoatmodel.renderToBuffer(matrixStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
        if (!entity.isUnderWater()) {
            VertexConsumer v = buffer.getBuffer(RenderType.waterMask());
            JBoatmodel.waterPatch().render(matrixStack, v, packedLight, OverlayTexture.NO_OVERLAY);
        }
        matrixStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks_, matrixStack, buffer, packedLight);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull JBoat entity) {
        return (ResourceLocation)this.getModelWithLocation(entity).getFirst();
    }

    public Pair<ResourceLocation, JBoatModel> getModelWithLocation(JBoat JBoat2) {
        return this.boatResources.get((Object)JBoat2.getJBoatType());
    }
}

