/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.render.world;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.jitl.client.render.world.clouds.BoilCloudRenderer;
import net.jitl.core.init.JITL;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class BoilRenderInfo
extends DimensionSpecialEffects {
    private static final ResourceLocation SUN_LOCATION = JITL.rl("textures/environment/boil_sun.png");
    private static final ResourceLocation BOIL_SKY_LOCATION = JITL.rl("textures/environment/boil_sky.png");
    private static final ResourceLocation CORBA_MOON_LOCATION = JITL.rl("textures/environment/corba_moon.png");
    private static final ResourceLocation EUCA_MOON_LOCATION = JITL.rl("textures/environment/euca_moon.png");

    public BoilRenderInfo() {
        super(150.0f, true, DimensionSpecialEffects.SkyType.NONE, false, false);
    }

    public boolean renderClouds(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, double camX, double camY, double camZ, Matrix4f modelViewMatrix, Matrix4f projectionMatrix) {
        new BoilCloudRenderer().render(level, ticks, poseStack, projectionMatrix, modelViewMatrix, partialTick, camX, camY, camZ);
        return true;
    }

    @NotNull
    public Vec3 getBrightnessDependentFogColor(Vec3 vector3d, float float_) {
        float color = 1.0f;
        return vector3d.multiply((double)(float_ * color), (double)(float_ * color), (double)(float_ * color));
    }

    public boolean isFoggyAt(int i, int i2) {
        return false;
    }

    public boolean renderSky(@NotNull ClientLevel level, int ticks, float partialTick, @NotNull Matrix4f frustumMatrix, @NotNull Camera camera, @NotNull Matrix4f projectionMatrix, boolean isFoggy, @NotNull Runnable setupFog) {
        FogType fogtype;
        Minecraft mc = Minecraft.getInstance();
        Tesselator tesselator = Tesselator.getInstance();
        setupFog.run();
        if (!isFoggy && (fogtype = camera.getFluidInCamera()) != FogType.POWDER_SNOW && fogtype != FogType.LAVA && !BoilRenderInfo.doesMobEffectBlockSky(camera)) {
            PoseStack posestack = new PoseStack();
            posestack.mulPose(frustumMatrix);
            this.renderSkyTexture(posestack);
            Vec3 vec3 = level.getSkyColor(mc.gameRenderer.getMainCamera().getPosition(), partialTick);
            float f = (float)vec3.x;
            float f1 = (float)vec3.y;
            float f2 = (float)vec3.z;
            FogRenderer.levelFogColor();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderColor((float)f, (float)f1, (float)f2, (float)1.0f);
            VertexBuffer.unbind();
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            posestack.pushPose();
            posestack.mulPose(Axis.XP.rotationDegrees(90.0f));
            float f3 = Mth.sin((float)level.getSunAngle(partialTick)) < 0.0f ? 180.0f : 0.0f;
            posestack.mulPose(Axis.ZP.rotationDegrees(f3));
            posestack.mulPose(Axis.ZP.rotationDegrees(90.0f));
            posestack.popPose();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            posestack.pushPose();
            posestack.mulPose(Axis.YP.rotationDegrees(-90.0f));
            posestack.mulPose(Axis.XP.rotationDegrees(level.getTimeOfDay(partialTick) * 360.0f));
            Matrix4f matrix4f1 = posestack.last().pose();
            float f12 = 80.0f;
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)SUN_LOCATION);
            BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            bufferbuilder.addVertex(matrix4f1, -f12, 100.0f, -f12).setUv(0.0f, 0.0f);
            bufferbuilder.addVertex(matrix4f1, f12, 100.0f, -f12).setUv(1.0f, 0.0f);
            bufferbuilder.addVertex(matrix4f1, f12, 100.0f, f12).setUv(1.0f, 1.0f);
            bufferbuilder.addVertex(matrix4f1, -f12, 100.0f, f12).setUv(0.0f, 1.0f);
            BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
            posestack.mulPose(Axis.YP.rotationDegrees(-45.0f));
            posestack.mulPose(Axis.XP.rotationDegrees(6600.0f));
            matrix4f1 = posestack.last().pose();
            f12 = 1.5f;
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)CORBA_MOON_LOCATION);
            bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            bufferbuilder.addVertex(matrix4f1, -f12, 100.0f, -f12).setUv(0.0f, 0.0f);
            bufferbuilder.addVertex(matrix4f1, f12, 100.0f, -f12).setUv(1.0f, 0.0f);
            bufferbuilder.addVertex(matrix4f1, f12, 100.0f, f12).setUv(1.0f, 1.0f);
            bufferbuilder.addVertex(matrix4f1, -f12, 100.0f, f12).setUv(0.0f, 1.0f);
            BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
            posestack.mulPose(Axis.YP.rotationDegrees(77.5f));
            posestack.mulPose(Axis.XP.rotationDegrees(level.getTimeOfDay(partialTick) * 360.0f + 2000.0f));
            matrix4f1 = posestack.last().pose();
            f12 = 4.0f;
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)EUCA_MOON_LOCATION);
            bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            bufferbuilder.addVertex(matrix4f1, -f12, 100.0f, -f12).setUv(0.0f, 0.0f);
            bufferbuilder.addVertex(matrix4f1, f12, 100.0f, -f12).setUv(1.0f, 0.0f);
            bufferbuilder.addVertex(matrix4f1, f12, 100.0f, f12).setUv(1.0f, 1.0f);
            bufferbuilder.addVertex(matrix4f1, -f12, 100.0f, f12).setUv(0.0f, 1.0f);
            BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            posestack.popPose();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.depthMask((boolean)true);
        }
        return true;
    }

    @Nullable
    public float[] getSunriseColor(float ff, float ff1) {
        return null;
    }

    private void renderSkyTexture(PoseStack poseStack) {
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BOIL_SKY_LOCATION);
        Tesselator tesselator = Tesselator.getInstance();
        for (int i = 0; i < 6; ++i) {
            poseStack.pushPose();
            switch (i) {
                default: {
                    break;
                }
                case 1: {
                    poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    break;
                }
                case 2: {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    break;
                }
                case 3: {
                    poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                    break;
                }
                case 4: {
                    poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                    break;
                }
                case 5: {
                    poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
                }
            }
            Matrix4f matrix4f = poseStack.last().pose();
            BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            bufferbuilder.addVertex(matrix4f, -100.0f, -100.0f, -100.0f).setUv(0.0f, 0.0f).setColor(40, 40, 40, 255);
            bufferbuilder.addVertex(matrix4f, -100.0f, -100.0f, 100.0f).setUv(0.0f, 16.0f).setColor(40, 40, 40, 255);
            bufferbuilder.addVertex(matrix4f, 100.0f, -100.0f, 100.0f).setUv(16.0f, 16.0f).setColor(40, 40, 40, 255);
            bufferbuilder.addVertex(matrix4f, 100.0f, -100.0f, -100.0f).setUv(16.0f, 0.0f).setColor(40, 40, 40, 255);
            BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
            poseStack.popPose();
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }

    public static boolean doesMobEffectBlockSky(Camera camera) {
        Entity entity = camera.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingentity = (LivingEntity)entity;
        return livingentity.hasEffect(MobEffects.BLINDNESS) || livingentity.hasEffect(MobEffects.DARKNESS);
    }
}

