/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.render.world;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.jitl.client.render.world.clouds.EucaCloudRenderer;
import net.jitl.core.init.JITL;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class EucaRenderInfo
extends DimensionSpecialEffects {
    private static final ResourceLocation CORBA_MOON_LOCATION = JITL.rl("textures/environment/corba_moon.png");

    public EucaRenderInfo() {
        super(0.0f, true, DimensionSpecialEffects.SkyType.NONE, false, false);
    }

    @NotNull
    public Vec3 getBrightnessDependentFogColor(Vec3 vector3d, float float_) {
        float color = 1.0f;
        return vector3d.multiply((double)(float_ * color), (double)(float_ * color), (double)(float_ * color));
    }

    public boolean renderClouds(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, double camX, double camY, double camZ, Matrix4f modelViewMatrix, Matrix4f projectionMatrix) {
        new EucaCloudRenderer().render(level, ticks, poseStack, projectionMatrix, modelViewMatrix, partialTick, camX, camY, camZ);
        return true;
    }

    public boolean renderSky(@NotNull ClientLevel level, int ticks, float partialTick, @NotNull Matrix4f frustumMatrix, @NotNull Camera camera, @NotNull Matrix4f projectionMatrix, boolean isFoggy, @NotNull Runnable setupFog) {
        Tesselator tesselator = Tesselator.getInstance();
        Minecraft mc = Minecraft.getInstance();
        setupFog.run();
        FogType fogtype = camera.getFluidInCamera();
        if (fogtype != FogType.POWDER_SNOW && fogtype != FogType.LAVA && !EucaRenderInfo.doesMobEffectBlockSky(camera)) {
            PoseStack poseStack = new PoseStack();
            poseStack.mulPose(frustumMatrix);
            Vec3 vec3 = level.getSkyColor(mc.gameRenderer.getMainCamera().getPosition(), partialTick);
            float f = (float)vec3.x;
            float f1 = (float)vec3.y;
            float f2 = (float)vec3.z;
            FogRenderer.levelFogColor();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderColor((float)f, (float)f1, (float)f2, (float)1.0f);
            VertexBuffer.unbind();
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.pushPose();
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            float f3 = Mth.sin((float)level.getSunAngle(partialTick)) < 0.0f ? 180.0f : 0.0f;
            poseStack.mulPose(Axis.ZP.rotationDegrees(f3));
            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
            poseStack.popPose();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            poseStack.pushPose();
            poseStack.mulPose(Axis.YP.rotationDegrees(-180.0f));
            poseStack.mulPose(Axis.XP.rotationDegrees(-24000.0f));
            Matrix4f matrix4f1 = poseStack.last().pose();
            float f12 = 20.0f;
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)CORBA_MOON_LOCATION);
            BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            bufferbuilder.addVertex(matrix4f1, -f12, 100.0f, -f12).setUv(0.0f, 0.0f);
            bufferbuilder.addVertex(matrix4f1, f12, 100.0f, -f12).setUv(1.0f, 0.0f);
            bufferbuilder.addVertex(matrix4f1, f12, 100.0f, f12).setUv(1.0f, 1.0f);
            bufferbuilder.addVertex(matrix4f1, -f12, 100.0f, f12).setUv(0.0f, 1.0f);
            BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            poseStack.popPose();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.depthMask((boolean)true);
        }
        return false;
    }

    public static boolean doesMobEffectBlockSky(Camera camera) {
        Entity entity = camera.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingentity = (LivingEntity)entity;
        return livingentity.hasEffect(MobEffects.BLINDNESS) || livingentity.hasEffect(MobEffects.DARKNESS);
    }

    public boolean isFoggyAt(int int_, int int1_) {
        return false;
    }
}

