/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.render.world.clouds;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public abstract class JCloudRenderer {
    private CloudStatus prevCloudsType;
    private Vec3 prevCloudColor = Vec3.ZERO;
    private VertexBuffer cloudBuffer;
    private int prevCloudX = Integer.MIN_VALUE;
    private int prevCloudY = Integer.MIN_VALUE;
    private int prevCloudZ = Integer.MIN_VALUE;
    private boolean generateClouds = true;

    public void render(ClientLevel level, int ticks, PoseStack pPoseStack, Matrix4f pProjectionMatrix, Matrix4f pFrustumMatrix, float pPartialTick, double pCamX, double pCamY, double pCamZ) {
        Minecraft minecraft = Minecraft.getInstance();
        float f = level.effects().getCloudHeight();
        if (!Float.isNaN(f)) {
            double d1 = ((float)ticks + pPartialTick) * 0.03f;
            double x = (pCamX + d1) / 12.0;
            double y = f - (float)pCamY + 0.33f;
            double z = pCamZ / 12.0 + (double)0.33f;
            x -= (double)(Mth.floor((double)(x / 2048.0)) * 2048);
            z -= (double)(Mth.floor((double)(z / 2048.0)) * 2048);
            float f3 = (float)(x - (double)Mth.floor((double)x));
            float f4 = (float)(y / 4.0 - (double)Mth.floor((double)(y / 4.0))) * 4.0f;
            float f5 = (float)(z - (double)Mth.floor((double)z));
            Vec3 vec3 = level.getCloudColor(pPartialTick);
            int x1 = (int)Math.floor(x);
            int y1 = (int)Math.floor(y / 4.0);
            int z1 = (int)Math.floor(z);
            if (x1 != this.prevCloudX || y1 != this.prevCloudY || z1 != this.prevCloudZ || minecraft.options.getCloudsType() != this.prevCloudsType || this.prevCloudColor.distanceToSqr(vec3) > 2.0E-4) {
                this.prevCloudX = x1;
                this.prevCloudY = y1;
                this.prevCloudZ = z1;
                this.prevCloudColor = vec3;
                this.prevCloudsType = minecraft.options.getCloudsType();
                this.generateClouds = true;
            }
            if (this.generateClouds) {
                this.generateClouds = false;
                if (this.cloudBuffer != null) {
                    this.cloudBuffer.close();
                }
                this.cloudBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
                this.cloudBuffer.bind();
                this.cloudBuffer.upload(this.buildClouds(Tesselator.getInstance(), x, y, z, vec3));
                VertexBuffer.unbind();
            }
            FogRenderer.levelFogColor();
            pPoseStack.pushPose();
            pPoseStack.mulPose(pFrustumMatrix);
            pPoseStack.scale(12.0f, 1.0f, 12.0f);
            pPoseStack.translate(-f3, f4, -f5);
            if (this.cloudBuffer != null) {
                int l;
                this.cloudBuffer.bind();
                for (int i1 = l = this.prevCloudsType == CloudStatus.FANCY ? 0 : 1; i1 < 2; ++i1) {
                    RenderType rendertype = i1 == 0 ? this.depthClouds() : this.clouds();
                    rendertype.setupRenderState();
                    ShaderInstance shaderinstance = RenderSystem.getShader();
                    assert (shaderinstance != null);
                    this.cloudBuffer.drawWithShader(pPoseStack.last().pose(), pProjectionMatrix, shaderinstance);
                    rendertype.clearRenderState();
                }
                VertexBuffer.unbind();
            }
            pPoseStack.popPose();
        }
    }

    public abstract RenderType clouds();

    public abstract RenderType depthClouds();

    private MeshData buildClouds(Tesselator t, double pX, double pY, double pZ, Vec3 pCloudColor) {
        float f3 = (float)Mth.floor((double)pX) * 0.00390625f;
        float f4 = (float)Mth.floor((double)pZ) * 0.00390625f;
        float f5 = (float)pCloudColor.x;
        float f6 = (float)pCloudColor.y;
        float f7 = (float)pCloudColor.z;
        float f8 = f5 * 0.9f;
        float f9 = f6 * 0.9f;
        float f10 = f7 * 0.9f;
        float f11 = f5 * 0.7f;
        float f12 = f6 * 0.7f;
        float f13 = f7 * 0.7f;
        float f14 = f5 * 0.8f;
        float f15 = f6 * 0.8f;
        float f16 = f7 * 0.8f;
        BufferBuilder bufferbuilder = t.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR_NORMAL);
        float f17 = (float)Math.floor(pY / 4.0) * 4.0f;
        if (this.prevCloudsType == CloudStatus.FANCY) {
            for (int k = -3; k <= 4; ++k) {
                for (int l = -3; l <= 4; ++l) {
                    float f18 = k * 8;
                    float f19 = l * 8;
                    if (f17 > -5.0f) {
                        bufferbuilder.addVertex(f18 + 0.0f, f17 + 0.0f, f19 + 8.0f).setUv((f18 + 0.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).setColor(f11, f12, f13, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                        bufferbuilder.addVertex(f18 + 8.0f, f17 + 0.0f, f19 + 8.0f).setUv((f18 + 8.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).setColor(f11, f12, f13, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                        bufferbuilder.addVertex(f18 + 8.0f, f17 + 0.0f, f19 + 0.0f).setUv((f18 + 8.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).setColor(f11, f12, f13, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                        bufferbuilder.addVertex(f18 + 0.0f, f17 + 0.0f, f19 + 0.0f).setUv((f18 + 0.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).setColor(f11, f12, f13, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                    }
                    if (f17 <= 5.0f) {
                        bufferbuilder.addVertex(f18 + 0.0f, f17 + 4.0f - 9.765625E-4f, f19 + 8.0f).setUv((f18 + 0.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).setColor(f5, f6, f7, 0.8f).setNormal(0.0f, 1.0f, 0.0f);
                        bufferbuilder.addVertex(f18 + 8.0f, f17 + 4.0f - 9.765625E-4f, f19 + 8.0f).setUv((f18 + 8.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).setColor(f5, f6, f7, 0.8f).setNormal(0.0f, 1.0f, 0.0f);
                        bufferbuilder.addVertex(f18 + 8.0f, f17 + 4.0f - 9.765625E-4f, f19 + 0.0f).setUv((f18 + 8.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).setColor(f5, f6, f7, 0.8f).setNormal(0.0f, 1.0f, 0.0f);
                        bufferbuilder.addVertex(f18 + 0.0f, f17 + 4.0f - 9.765625E-4f, f19 + 0.0f).setUv((f18 + 0.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).setColor(f5, f6, f7, 0.8f).setNormal(0.0f, 1.0f, 0.0f);
                    }
                    if (k > -1) {
                        for (int i1 = 0; i1 < 8; ++i1) {
                            bufferbuilder.addVertex(f18 + (float)i1 + 0.0f, f17 + 0.0f, f19 + 8.0f).setUv((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).setColor(f8, f9, f10, 0.8f).setNormal(-1.0f, 0.0f, 0.0f);
                            bufferbuilder.addVertex(f18 + (float)i1 + 0.0f, f17 + 4.0f, f19 + 8.0f).setUv((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).setColor(f8, f9, f10, 0.8f).setNormal(-1.0f, 0.0f, 0.0f);
                            bufferbuilder.addVertex(f18 + (float)i1 + 0.0f, f17 + 4.0f, f19 + 0.0f).setUv((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).setColor(f8, f9, f10, 0.8f).setNormal(-1.0f, 0.0f, 0.0f);
                            bufferbuilder.addVertex(f18 + (float)i1 + 0.0f, f17 + 0.0f, f19 + 0.0f).setUv((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).setColor(f8, f9, f10, 0.8f).setNormal(-1.0f, 0.0f, 0.0f);
                        }
                    }
                    if (k <= 1) {
                        for (int j2 = 0; j2 < 8; ++j2) {
                            bufferbuilder.addVertex(f18 + (float)j2 + 1.0f - 9.765625E-4f, f17 + 0.0f, f19 + 8.0f).setUv((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).setColor(f8, f9, f10, 0.8f).setNormal(1.0f, 0.0f, 0.0f);
                            bufferbuilder.addVertex(f18 + (float)j2 + 1.0f - 9.765625E-4f, f17 + 4.0f, f19 + 8.0f).setUv((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).setColor(f8, f9, f10, 0.8f).setNormal(1.0f, 0.0f, 0.0f);
                            bufferbuilder.addVertex(f18 + (float)j2 + 1.0f - 9.765625E-4f, f17 + 4.0f, f19 + 0.0f).setUv((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).setColor(f8, f9, f10, 0.8f).setNormal(1.0f, 0.0f, 0.0f);
                            bufferbuilder.addVertex(f18 + (float)j2 + 1.0f - 9.765625E-4f, f17 + 0.0f, f19 + 0.0f).setUv((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).setColor(f8, f9, f10, 0.8f).setNormal(1.0f, 0.0f, 0.0f);
                        }
                    }
                    if (l > -1) {
                        for (int k2 = 0; k2 < 8; ++k2) {
                            bufferbuilder.addVertex(f18 + 0.0f, f17 + 4.0f, f19 + (float)k2 + 0.0f).setUv((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).setColor(f14, f15, f16, 0.8f).setNormal(0.0f, 0.0f, -1.0f);
                            bufferbuilder.addVertex(f18 + 8.0f, f17 + 4.0f, f19 + (float)k2 + 0.0f).setUv((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).setColor(f14, f15, f16, 0.8f).setNormal(0.0f, 0.0f, -1.0f);
                            bufferbuilder.addVertex(f18 + 8.0f, f17 + 0.0f, f19 + (float)k2 + 0.0f).setUv((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).setColor(f14, f15, f16, 0.8f).setNormal(0.0f, 0.0f, -1.0f);
                            bufferbuilder.addVertex(f18 + 0.0f, f17 + 0.0f, f19 + (float)k2 + 0.0f).setUv((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).setColor(f14, f15, f16, 0.8f).setNormal(0.0f, 0.0f, -1.0f);
                        }
                    }
                    if (l > 1) continue;
                    for (int l2 = 0; l2 < 8; ++l2) {
                        bufferbuilder.addVertex(f18 + 0.0f, f17 + 4.0f, f19 + (float)l2 + 1.0f - 9.765625E-4f).setUv((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).setColor(f14, f15, f16, 0.8f).setNormal(0.0f, 0.0f, 1.0f);
                        bufferbuilder.addVertex(f18 + 8.0f, f17 + 4.0f, f19 + (float)l2 + 1.0f - 9.765625E-4f).setUv((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).setColor(f14, f15, f16, 0.8f).setNormal(0.0f, 0.0f, 1.0f);
                        bufferbuilder.addVertex(f18 + 8.0f, f17 + 0.0f, f19 + (float)l2 + 1.0f - 9.765625E-4f).setUv((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).setColor(f14, f15, f16, 0.8f).setNormal(0.0f, 0.0f, 1.0f);
                        bufferbuilder.addVertex(f18 + 0.0f, f17 + 0.0f, f19 + (float)l2 + 1.0f - 9.765625E-4f).setUv((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).setColor(f14, f15, f16, 0.8f).setNormal(0.0f, 0.0f, 1.0f);
                    }
                }
            }
        } else {
            for (int l1 = -32; l1 < 32; l1 += 32) {
                for (int i2 = -32; i2 < 32; i2 += 32) {
                    bufferbuilder.addVertex((float)(l1 + 0), f17, (float)(i2 + 32)).setUv((float)(l1 + 0) * 0.00390625f + f3, (float)(i2 + 32) * 0.00390625f + f4).setColor(f5, f6, f7, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                    bufferbuilder.addVertex((float)(l1 + 32), f17, (float)(i2 + 32)).setUv((float)(l1 + 32) * 0.00390625f + f3, (float)(i2 + 32) * 0.00390625f + f4).setColor(f5, f6, f7, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                    bufferbuilder.addVertex((float)(l1 + 32), f17, (float)(i2 + 0)).setUv((float)(l1 + 32) * 0.00390625f + f3, (float)(i2 + 0) * 0.00390625f + f4).setColor(f5, f6, f7, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                    bufferbuilder.addVertex((float)(l1 + 0), f17, (float)(i2 + 0)).setUv((float)(l1 + 0) * 0.00390625f + f3, (float)(i2 + 0) * 0.00390625f + f4).setColor(f5, f6, f7, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                }
            }
        }
        return bufferbuilder.buildOrThrow();
    }
}

